/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase;

import liquibase.database.Database;
import liquibase.snapshot.SnapshotListener;
import liquibase.structure.DatabaseObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class LBSnapshotListener
implements SnapshotListener {
    private final String name;
    private final DBRProgressMonitor monitor;

    public LBSnapshotListener(String name, DBRProgressMonitor monitor) {
        this.name = name;
        this.monitor = monitor;
    }

    private String getSchema(DatabaseObject example) {
        if (example.getSchema() == null) {
            return "";
        }
        return example.getSchema().getName() == null ? "" : String.valueOf(example.getSchema().getName()) + ".";
    }

    public void willSnapshot(DatabaseObject example, Database database) {
        if (example != null && example.getName() != null && this.monitor != null) {
            this.monitor.subTask("[" + this.name + "] Prepare snapshot for " + this.getSchema(example) + example.getName());
        }
    }

    public void finishedSnapshot(DatabaseObject example, DatabaseObject snapshot, Database database) {
        if (example != null && example.getName() != null && this.monitor != null) {
            this.monitor.subTask("[" + this.name + "] " + this.getSchema(example) + example.getName() + " done.");
        }
    }
}

