/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.sqlgenerator;

import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.ModifyDataTypeGenerator;
import liquibase.statement.core.ModifyDataTypeStatement;
import liquibase.structure.DatabaseObject;

public class ModifyDataTypeGeneratorVertica
extends ModifyDataTypeGenerator {
    public Sql[] generateSql(ModifyDataTypeStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String alterTable = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName());
        alterTable = alterTable + " " + this.getModifyString(database) + " ";
        alterTable = alterTable + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName());
        alterTable = alterTable + this.getPreDataTypeString(database);
        alterTable = alterTable + DataTypeFactory.getInstance().fromDescription(statement.getNewDataType(), database).toDatabaseDataType(database);
        return new Sql[]{new UnparsedSql(alterTable, new DatabaseObject[]{this.getAffectedTable(statement)})};
    }

    protected String getModifyString(Database database) {
        return "ALTER COLUMN";
    }

    protected String getPreDataTypeString(Database database) {
        return " SET DATA TYPE ";
    }

    public boolean supports(ModifyDataTypeStatement statement, Database database) {
        return database instanceof VerticaDatabase;
    }
}

