/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.sqlgenerator;

import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.ext.vertica.statement.AddVerticaColumnStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddColumnGenerator;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.core.AddColumnStatement;
import liquibase.structure.DatabaseObject;

public class AddVerticaColumnGenerator
extends AddColumnGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(AddColumnStatement statement, Database database) {
        return database instanceof VerticaDatabase;
    }

    public Sql[] generateSql(AddColumnStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        AddVerticaColumnStatement verticaColumnStatement = (AddVerticaColumnStatement)statement;
        String alterTable = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " ADD " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()) + " " + DataTypeFactory.getInstance().fromDescription(statement.getColumnType() + (statement.isAutoIncrement() ? "{autoIncrement:true}" : ""), database).toDatabaseDataType(database);
        if (statement.isAutoIncrement() && database.supportsAutoIncrement()) {
            AutoIncrementConstraint autoIncrementConstraint = statement.getAutoIncrementConstraint();
            alterTable = alterTable + " " + database.getAutoIncrementClause(autoIncrementConstraint.getStartWith(), autoIncrementConstraint.getIncrementBy());
        }
        if (!statement.isNullable()) {
            alterTable = alterTable + " NOT NULL";
        } else if (database instanceof SybaseDatabase || database instanceof SybaseASADatabase || database instanceof MySQLDatabase) {
            alterTable = alterTable + " NULL";
        }
        if (statement.isPrimaryKey()) {
            alterTable = alterTable + " PRIMARY KEY";
        }
        if (verticaColumnStatement.getEncoding() != null) {
            alterTable = alterTable + " ENCODING " + verticaColumnStatement.getEncoding();
        }
        if (verticaColumnStatement.getAccessrank() != null) {
            alterTable = alterTable + " ACCESSRANK " + verticaColumnStatement.getAccessrank();
        }
        System.out.println(alterTable);
        ArrayList<UnparsedSql> returnSql = new ArrayList<UnparsedSql>();
        returnSql.add(new UnparsedSql(alterTable, new DatabaseObject[]{this.getAffectedColumn(statement)}));
        this.addUniqueConstrantStatements(statement, database, returnSql);
        this.addForeignKeyStatements(statement, database, returnSql);
        return returnSql.toArray(new Sql[returnSql.size()]);
    }
}

