/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.snapshot;

import java.sql.SQLException;
import java.util.List;
import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.ext.vertica.snapshot.VerticaDatabaseSnapshot;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.snapshot.jvm.TableSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.StringUtils;

public class TableSnapshotGeneratorVertica
extends JdbcSnapshotGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof VerticaDatabase) {
            return 5;
        }
        return -1;
    }

    public TableSnapshotGeneratorVertica() {
        super(Table.class, new Class[]{Schema.class});
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        Database database = snapshot.getDatabase();
        String objectName = example.getName();
        Schema schema = example.getSchema();
        List<CachedRow> rs = null;
        try {
            VerticaDatabaseSnapshot verticaDatabaseSnapshot = new VerticaDatabaseSnapshot(new DatabaseObject[0], snapshot.getDatabase(), snapshot.getSnapshotControl());
            rs = verticaDatabaseSnapshot.getMetaData().getTables(schema.getName(), example.getName());
            if (rs.size() <= 0) {
                return null;
            }
            Table table = this.readTable(rs.get(0), database);
            return table;
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Table.class)) {
            return;
        }
        if (foundObject instanceof Schema) {
            Database database = snapshot.getDatabase();
            Schema schema = (Schema)foundObject;
            List tableMetaDataRs = null;
            try {
                tableMetaDataRs = ((JdbcDatabaseSnapshot)snapshot).getMetaData().getTables(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), null);
                for (CachedRow row : tableMetaDataRs) {
                    String tableName = row.getString("TABLE_NAME");
                    Table tableExample = (Table)new Table().setName(this.cleanNameFromDatabase(tableName, database)).setSchema(schema);
                    schema.addDatabaseObject((DatabaseObject)tableExample);
                }
            }
            catch (SQLException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    }

    protected Table readTable(CachedRow tableMetadataResultSet, Database database) throws SQLException, DatabaseException {
        String rawTableName = tableMetadataResultSet.getString("TABLE_NAME");
        String rawSchemaName = StringUtils.trimToNull((String)tableMetadataResultSet.getString("TABLE_SCHEM"));
        String rawCatalogName = StringUtils.trimToNull((String)tableMetadataResultSet.getString("TABLE_CAT"));
        String remarks = StringUtils.trimToNull((String)tableMetadataResultSet.getString("REMARKS"));
        if (remarks != null) {
            remarks = remarks.replace("''", "'");
        }
        Table table = new Table().setName(this.cleanNameFromDatabase(rawTableName, database));
        table.setRemarks(remarks);
        CatalogAndSchema schemaFromJdbcInfo = ((AbstractJdbcDatabase)database).getSchemaFromJdbcInfo(rawCatalogName, rawSchemaName);
        table.setSchema(new Schema(schemaFromJdbcInfo.getCatalogName(), schemaFromJdbcInfo.getSchemaName()));
        String partitionby = ((VerticaDatabase)database).executeSQL("select partition_expression from tables where table_name ='" + table.getName() + "'");
        if (partitionby != null && !partitionby.isEmpty()) {
            table.setAttribute("partitionby", (Object)partitionby);
        }
        return table;
    }

    public Class<? extends SnapshotGenerator>[] replaces() {
        return new Class[]{TableSnapshotGenerator.class};
    }
}

