/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.diff.output.changelog;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.CatalogAndSchema;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorFactory;
import liquibase.diff.output.changelog.ChangedObjectChangeGenerator;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.DatabaseObject;
import liquibase.structure.DatabaseObjectComparator;
import liquibase.util.StringUtils;

public class DiffToChangeSetLog
extends DiffToChangeLog {
    private String changeSetContext;
    private DiffResult diffResult;
    private DiffOutputControl diffOutputControl;

    public DiffToChangeSetLog(DiffResult diffResult, DiffOutputControl diffOutputControl) {
        super(diffResult, diffOutputControl);
        this.diffResult = diffResult;
        this.diffOutputControl = diffOutputControl;
    }

    public DiffToChangeSetLog(DiffOutputControl diffOutputControl) {
        super(diffOutputControl);
        this.diffOutputControl = diffOutputControl;
    }

    public void setChangeSetContext(String changeSetContext) {
        this.changeSetContext = changeSetContext;
    }

    public List<ChangeSet> generateChangeSets() {
        Change[] changes;
        ChangeGeneratorFactory changeGeneratorFactory = ChangeGeneratorFactory.getInstance();
        DatabaseObjectComparator comparator = new DatabaseObjectComparator();
        ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
        ObjectQuotingStrategy quotingStrategy = ObjectQuotingStrategy.QUOTE_ALL_OBJECTS;
        ChangeSet changeSet = new ChangeSet(this.generateId(), this.getChangeSetAuthor(), false, false, null, this.changeSetContext, null, quotingStrategy, null);
        List types = this.getOrderedOutputTypes(MissingObjectChangeGenerator.class);
        for (Class type : types) {
            for (DatabaseObject databaseObject : this.diffResult.getMissingObjects(type, (Comparator)comparator)) {
                if (databaseObject == null) continue;
                changes = changeGeneratorFactory.fixMissing(databaseObject, this.diffOutputControl, this.diffResult.getReferenceSnapshot().getDatabase(), this.diffResult.getComparisonSnapshot().getDatabase());
                if (this.diffResult.getReferenceSnapshot().getDatabase().isLiquibaseObject(databaseObject) || this.diffResult.getReferenceSnapshot().getDatabase().isSystemObject(databaseObject)) continue;
                this.addToChangeSet(changes, changeSet);
            }
        }
        types = this.getOrderedOutputTypes(UnexpectedObjectChangeGenerator.class);
        for (Class type : types) {
            for (DatabaseObject databaseObject : this.diffResult.getUnexpectedObjects(type, (Comparator)comparator)) {
                changes = changeGeneratorFactory.fixUnexpected(databaseObject, this.diffOutputControl, this.diffResult.getReferenceSnapshot().getDatabase(), this.diffResult.getComparisonSnapshot().getDatabase());
                if (this.diffResult.getComparisonSnapshot().getDatabase().isLiquibaseObject(databaseObject) || this.diffResult.getComparisonSnapshot().getDatabase().isSystemObject(databaseObject)) continue;
                this.addToChangeSet(changes, changeSet);
            }
        }
        types = this.getOrderedOutputTypes(ChangedObjectChangeGenerator.class);
        for (Class type : types) {
            for (Map.Entry entry : this.diffResult.getChangedObjects(type, (Comparator)comparator).entrySet()) {
                changes = changeGeneratorFactory.fixChanged((DatabaseObject)entry.getKey(), (ObjectDifferences)entry.getValue(), this.diffOutputControl, this.diffResult.getReferenceSnapshot().getDatabase(), this.diffResult.getComparisonSnapshot().getDatabase());
                if (this.diffResult.getReferenceSnapshot().getDatabase().isLiquibaseObject((DatabaseObject)entry.getKey()) || this.diffResult.getReferenceSnapshot().getDatabase().isSystemObject((DatabaseObject)entry.getKey())) continue;
                this.addToChangeSet(changes, changeSet);
            }
        }
        changeSets.add(changeSet);
        return changeSets;
    }

    private void addToChangeSet(Change[] changes, ChangeSet changeSet) {
        if (changes != null) {
            for (Change change : changes) {
                changeSet.addChange(change);
            }
        }
    }

    public static void doGenerateChangeLog(String changeLogFile, Database originalDatabase, String catalogName, String schemaName, String snapshotTypes, String author, String context, String dataDir, DiffOutputControl diffOutputControl) throws DatabaseException, IOException, ParserConfigurationException, InvalidExampleException {
        SnapshotControl snapshotControl = new SnapshotControl(originalDatabase, snapshotTypes);
        CompareControl compareControl = new CompareControl(new CompareControl.SchemaComparison[]{new CompareControl.SchemaComparison(new CatalogAndSchema(catalogName, schemaName), new CatalogAndSchema(catalogName, schemaName))}, snapshotTypes);
        diffOutputControl.setDataDir(dataDir);
        DatabaseSnapshot originalDatabaseSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(compareControl.getSchemas(CompareControl.DatabaseRole.REFERENCE), originalDatabase, snapshotControl);
        DiffResult diffResult = DiffGeneratorFactory.getInstance().compare(originalDatabaseSnapshot, SnapshotGeneratorFactory.getInstance().createSnapshot(compareControl.getSchemas(CompareControl.DatabaseRole.REFERENCE), null, snapshotControl), compareControl);
        DiffToChangeSetLog changeLogWriter = new DiffToChangeSetLog(diffResult, diffOutputControl);
        changeLogWriter.setChangeSetAuthor(author);
        changeLogWriter.setChangeSetContext(context);
        if (StringUtils.trimToNull((String)changeLogFile) != null) {
            changeLogWriter.print(changeLogFile);
        } else {
            PrintStream outputStream = System.out;
            changeLogWriter.print(outputStream);
        }
    }
}

