/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops;

import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabel;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

public class SelfLoopLabelPosition {
    private final SelfLoopLabel label;
    private PortSide side;
    private final KVector position;
    private final KVector originalPosition;
    private LabelAlignment labelAlignment;
    private double basePenalty;

    public SelfLoopLabelPosition(SelfLoopLabel label, KVector position) {
        this.label = label;
        this.originalPosition = position.clone();
        this.position = position.clone();
    }

    public SelfLoopLabel getLabel() {
        return this.label;
    }

    public PortSide getSide() {
        return this.side;
    }

    public void setSide(PortSide side) {
        this.side = side;
    }

    public void resetPosition() {
        this.position.set(this.originalPosition);
    }

    public KVector getPosition() {
        return this.position;
    }

    public KVector getOriginalPosition() {
        return this.originalPosition;
    }

    public LabelAlignment getLabelAlignment() {
        return this.labelAlignment;
    }

    public void setLabelAlignment(LabelAlignment labelAlignment) {
        this.labelAlignment = labelAlignment;
    }

    public double getBasePenalty() {
        return this.basePenalty;
    }

    public void setBasePenalty(double penalty) {
        this.basePenalty = penalty;
    }

    public String toString() {
        return this.side + " " + this.position.toString();
    }

    public static enum LabelAlignment {
        LEFT,
        CENTERED,
        RIGHT;

    }
}

