/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.exec;

import com.dbeaver.ee.mongodb.exec.MongoBaseStatement;
import com.dbeaver.ee.mongodb.exec.MongoSession;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractResultSet;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class MongoResultSet
extends AbstractResultSet<MongoSession, MongoBaseStatement>
implements DBRBlockingObject {
    private final DBCursor cursor;
    private final List<DBObject> list;
    private DBCResultSetMetaData metaData;
    private DBObject curRow;
    private long rowCount = 0L;

    public MongoResultSet(MongoBaseStatement statement, DBCursor cursor) {
        super((DBCSession)statement.getSession(), (DBCStatement)statement);
        long limit;
        this.cursor = cursor;
        this.list = null;
        long offset = statement.getOffset();
        if (offset > 0L) {
            this.cursor.skip((int)offset);
        }
        if ((limit = statement.getLimit()) > 0L) {
            this.cursor.limit((int)limit);
        }
        if (statement.getSession().isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
        statement.getSession().getProgressMonitor().startBlock((DBRBlockingObject)this, "Fetch result");
    }

    public MongoResultSet(MongoBaseStatement statement, List<DBObject> list) {
        super((DBCSession)statement.getSession(), (DBCStatement)statement);
        this.cursor = null;
        this.list = list;
        if (statement.getSession().isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
        statement.getSession().getProgressMonitor().startBlock((DBRBlockingObject)this, "Fetch result");
    }

    public MongoSession getSession() {
        return ((MongoBaseStatement)this.statement).getSession();
    }

    public MongoBaseStatement getSourceStatement() {
        return (MongoBaseStatement)this.statement;
    }

    private void checkRowFetched() throws DBCException {
        if (this.curRow == null) {
            throw new DBCException("Row not fetched");
        }
    }

    public Object getAttributeValue(int index) throws DBCException {
        this.checkRowFetched();
        if (index == 0) {
            return this.curRow;
        }
        throw new DBCException("Index out of range (" + index + ")");
    }

    public Object getAttributeValue(String name) throws DBCException {
        this.checkRowFetched();
        return this.curRow.get(name);
    }

    public boolean nextRow() throws DBCException {
        if (this.list != null) {
            if ((long)this.list.size() > this.rowCount) {
                this.curRow = this.list.get((int)this.rowCount);
                ++this.rowCount;
                return true;
            }
            return false;
        }
        if (!this.cursor.hasNext()) {
            this.curRow = null;
            return false;
        }
        this.curRow = this.cursor.next();
        ++this.rowCount;
        return true;
    }

    public boolean moveTo(int position) throws DBCException {
        return false;
    }

    @NotNull
    public DBCResultSetMetaData getMeta() throws DBCException {
        if (this.metaData == null) {
            this.metaData = ((MongoBaseStatement)this.statement).createMetadata();
        }
        return this.metaData;
    }

    public String getResultSetName() throws DBCException {
        return null;
    }

    public Object getFeature(String name) {
        if ("document".equals(name)) {
            return true;
        }
        return null;
    }

    public void close() {
        ((MongoBaseStatement)this.statement).getSession().getProgressMonitor().endBlock();
        if (((MongoBaseStatement)this.statement).getSession().isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetClose((DBCResultSet)this, this.rowCount);
        }
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        this.cursor.close();
    }
}

