/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.data;

import com.dbeaver.ee.mongodb.MongoUtils;
import com.dbeaver.ee.mongodb.model.MongoDataSource;
import com.mongodb.BasicDBList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MongoListValue
implements DBDCollection,
DBDValueCloneable {
    private final MongoDataSource dataSource;
    private BasicDBList contents;
    private final DBSDataType type;
    private DBDValueHandler valueHandler;
    private List<Object> listValues;
    private boolean modified;

    public MongoListValue(MongoDataSource dataSource, BasicDBList contents) {
        this.dataSource = dataSource;
        this.contents = contents;
        if (contents == null || contents.isEmpty()) {
            this.type = dataSource.getDataType(3);
            this.listValues = new ArrayList<Object>();
        } else {
            this.type = dataSource.getDataType(MongoUtils.resolveValueType(contents.get(0)));
            this.listValues = new ArrayList<Object>(contents.size());
            int i = 0;
            while (i < contents.size()) {
                this.listValues.add(MongoUtils.wrapMongoValue(dataSource, contents.get(i), this));
                ++i;
            }
        }
    }

    @NotNull
    public DBSDataType getComponentType() {
        return this.type;
    }

    @NotNull
    public DBDValueHandler getComponentValueHandler() {
        if (this.valueHandler == null) {
            this.valueHandler = DBUtils.findValueHandler((DBPDataSource)this.dataSource, (DBSTypedObject)this.type);
        }
        return this.valueHandler;
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) {
        MongoListValue copy = new MongoListValue(this.dataSource, this.contents);
        return copy;
    }

    public BasicDBList getRawValue() {
        return this.contents;
    }

    public boolean isNull() {
        return this.contents == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void release() {
        this.contents = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "[NULL]";
        }
        return this.makeArrayString();
    }

    @NotNull
    public String makeArrayString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.contents.toString();
    }

    public int getItemCount() {
        return this.contents == null ? 0 : this.contents.size();
    }

    public Object getItem(int index) {
        return this.listValues.get(index);
    }

    public void setItem(int index, Object value) {
        this.contents.set(index, value);
        this.listValues.set(index, DBUtils.getRawValue((Object)value));
        this.modified = true;
    }

    public void setContents(Object[] contents) {
        this.contents.clear();
        this.listValues.clear();
        Collections.addAll(this.listValues, contents);
        this.contents.addAll(this.listValues);
        this.modified = true;
    }
}

