/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.model;

import com.dbeaver.ee.redis.RedisUtils;
import com.dbeaver.ee.redis.model.RedisDataSource;
import com.dbeaver.ee.redis.model.RedisKey;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;

public class RedisDatabase
implements DBSSchema,
DBPSaveableObject,
DBPSystemObject {
    private static final Log log = Log.getLog(RedisDatabase.class);
    private final RedisDataSource dataSource;
    private final String dbName;
    private boolean persisted;
    private List<RedisKey> keyList;
    private List<RedisKey> keyTree;
    private int id;

    public RedisDatabase(RedisDataSource dataSource, String dbName) {
        this.dataSource = dataSource;
        this.dbName = dbName;
        if (this.dbName.startsWith("db")) {
            try {
                this.id = Integer.parseInt(this.dbName.substring(2));
            }
            catch (Exception e) {
                log.error((Object)"Can't extract DB id", (Throwable)e);
            }
        }
        this.persisted = true;
    }

    @NotNull
    public RedisDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.dbName;
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public Collection<DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return null;
    }

    public Class<DBSObject> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return DBSObject.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSystem() {
        return false;
    }

    @Association
    public List<RedisKey> getKeyList(DBRProgressMonitor monitor) throws DBCException {
        if (this.keyList == null) {
            this.keyList = RedisUtils.getKeys(monitor, this, null, null, false);
        }
        return this.keyList;
    }

    @Association
    public List<RedisKey> getKeyTree(DBRProgressMonitor monitor) throws DBCException {
        if (this.keyTree == null) {
            this.keyTree = RedisUtils.getKeys(monitor, this, null, null, true);
        }
        return this.keyTree;
    }
}

