/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.Header;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class OutMessage {
    final EXAConnection connection;
    private EXAOutputStream out;
    private ByteArrayOutputStream outData;
    private Header header;
    private DebugLog debug;

    public OutMessage(DebugLog debugLog, EXAConnection eXAConnection) {
        this.connection = eXAConnection;
        this.outData = new ByteArrayOutputStream();
        this.out = new EXAOutputStream(this.outData, eXAConnection);
        this.debug = debugLog;
        this.header = new Header(eXAConnection, debugLog, eXAConnection.getNextSerialNumber());
    }

    public EXAOutputStream getStream() {
        return this.out;
    }

    public Header getHeader() {
        return this.header;
    }

    public void flush() throws IOException {
        this.out.flush();
        this.header.setSize(this.outData.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write_to(OutputStream outputStream, EXAConnection eXAConnection) throws IOException, ConnectionException {
        try {
            this.out.flush();
            this.header.write_to(outputStream);
            outputStream.write(this.outData.toByteArray());
        }
        finally {
            this.outData.reset();
        }
    }

    public void write_to_and_no_clean(OutputStream outputStream, EXAConnection eXAConnection) throws IOException, ConnectionException {
        this.out.flush();
        this.header.write_to(outputStream);
        outputStream.write(this.outData.toByteArray());
        outputStream.flush();
    }
}

