/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable.exec;

import com.dbeaver.db.google.bigtable.data.BigTableDocument;
import com.dbeaver.db.google.bigtable.exec.BigTableBaseStatement;
import com.dbeaver.db.google.bigtable.exec.BigTableScanStatement;
import com.dbeaver.db.google.bigtable.exec.BigTableSession;
import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigtable.data.v2.models.Row;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractResultSet;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetMeta;

public class BigTableResultSet
extends AbstractResultSet<BigTableSession, BigTableBaseStatement> {
    private final ServerStream<Row> rows;
    private Iterator<Row> rowIterator;
    private DBCResultSetMetaData metaData;
    private int itemNumber;
    private Row curRow;

    public BigTableResultSet(BigTableBaseStatement statement, ServerStream<Row> rows) {
        super((DBCSession)((BigTableSession)statement.getSession()), (DBCStatement)statement);
        this.rows = rows;
        this.itemNumber = -1;
    }

    public BigTableSession getSession() {
        return (BigTableSession)((BigTableBaseStatement)this.statement).getSession();
    }

    public BigTableBaseStatement getSourceStatement() {
        return (BigTableBaseStatement)this.statement;
    }

    private void checkRowFetched() throws DBCException {
        if (this.curRow == null) {
            throw new DBCException("Row not fetched");
        }
    }

    public Object getAttributeValue(int index) throws DBCException {
        this.checkRowFetched();
        if (index == 0) {
            return new BigTableDocument(this.getSession().getDataSource(), this.statement instanceof BigTableScanStatement ? ((BigTableScanStatement)this.statement).getTable() : null, this.curRow);
        }
        throw new DBCException("Index out of range (" + index + ")");
    }

    public Object getAttributeValue(String name) throws DBCException {
        this.checkRowFetched();
        return new BigTableDocument(this.getSession().getDataSource(), this.statement instanceof BigTableScanStatement ? ((BigTableScanStatement)this.statement).getTable() : null, this.curRow);
    }

    public boolean nextRow() throws DBCException {
        if (this.rowIterator == null) {
            this.rowIterator = this.rows.iterator();
        }
        if (this.rowIterator.hasNext()) {
            this.curRow = this.rowIterator.next();
            ++this.itemNumber;
            return true;
        }
        return false;
    }

    public boolean moveTo(int position) throws DBCException {
        throw new DBCException("No supported");
    }

    @NotNull
    public DBCResultSetMetaData getMeta() throws DBCException {
        if (this.metaData == null) {
            this.metaData = new LocalResultSetMeta(Collections.singletonList(new DynamicDocumentAttribute()));
        }
        return this.metaData;
    }

    public String getResultSetName() throws DBCException {
        return null;
    }

    public Object getFeature(String name) {
        return null;
    }

    public void close() {
        if (this.rowIterator != null) {
            this.rowIterator = null;
        }
        this.rows.cancel();
    }

    private DBCEntityMetaData makeEntityMetaData(DBCAttributeMetaData attributeMeta) {
        return new DocumentEntityMetaData(attributeMeta);
    }

    private class DocumentEntityMetaData
    implements DBCEntityMetaData {
        private final DBCAttributeMetaData attributeMeta;

        DocumentEntityMetaData(DBCAttributeMetaData attributeMeta) {
            this.attributeMeta = attributeMeta;
        }

        public String getCatalogName() {
            return null;
        }

        public String getSchemaName() {
            return null;
        }

        @NotNull
        public String getEntityName() {
            return ((BigTableBaseStatement)BigTableResultSet.this.statement).getEntityName();
        }

        @NotNull
        public List<? extends DBCAttributeMetaData> getAttributes() {
            return Collections.singletonList(this.attributeMeta);
        }
    }

    public class DynamicDocumentAttribute
    implements DBCAttributeMetaData {
        public String getFullTypeName() {
            return this.getTypeName();
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        public Integer getScale() {
            return 0;
        }

        public Integer getPrecision() {
            return 0;
        }

        public long getMaxLength() {
            return 0L;
        }

        public boolean isReadOnly() {
            return true;
        }

        public DBCEntityMetaData getEntityMetaData() {
            return BigTableResultSet.this.makeEntityMetaData(this);
        }

        @NotNull
        public String getName() {
            return "BigTableRow";
        }

        public String getTypeName() {
            return "json";
        }

        public int getTypeID() {
            return 0;
        }

        public DBPDataKind getDataKind() {
            return DBPDataKind.DOCUMENT;
        }

        public int getOrdinalPosition() {
            return 0;
        }

        public Object getSource() {
            return BigTableResultSet.this.statement;
        }

        @NotNull
        public String getLabel() {
            return this.getName();
        }

        public String getEntityName() {
            return ((BigTableBaseStatement)BigTableResultSet.this.statement).getEntityName();
        }
    }
}

