/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.teradata.sqlgenerator;

import java.util.List;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.ext.teradata.database.TeradataDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.DropIndexGenerator;
import liquibase.statement.core.DropIndexStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Index;
import liquibase.util.StringUtils;

public class DropIndexGeneratorTeradata
extends DropIndexGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(DropIndexStatement statement, Database database) {
        return database instanceof TeradataDatabase;
    }

    public Sql[] generateSql(DropIndexStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        List associatedWith = StringUtils.splitAndTrim((String)statement.getAssociatedWith(), (String)",");
        if (associatedWith != null) {
            if (associatedWith.contains("primaryKey") || associatedWith.contains("uniqueConstraint")) {
                return new Sql[0];
            }
            if (associatedWith.contains("foreignKey") && !(database instanceof OracleDatabase) && !(database instanceof MSSQLDatabase)) {
                return new Sql[0];
            }
        }
        String schemaName = statement.getTableSchemaName();
        return new Sql[]{new UnparsedSql("DROP INDEX " + database.escapeObjectName(statement.getIndexName(), Index.class) + " ON " + database.escapeTableName(statement.getTableCatalogName(), schemaName, statement.getTableName()), new DatabaseObject[0])};
    }
}

