/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.teradata.sqlgenerator;

import java.util.Arrays;
import java.util.Iterator;
import liquibase.change.AddColumnConfig;
import liquibase.database.Database;
import liquibase.ext.teradata.database.TeradataDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateIndexGenerator;
import liquibase.statement.core.CreateIndexStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Index;

public class CreateIndexGeneratorTeradata
extends CreateIndexGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(CreateIndexStatement statement, Database database) {
        return database instanceof TeradataDatabase;
    }

    public Sql[] generateSql(CreateIndexStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE ");
        if (statement.isUnique() != null && statement.isUnique().booleanValue()) {
            buffer.append("UNIQUE ");
        }
        buffer.append("INDEX ");
        if (statement.getIndexName() != null) {
            buffer.append(database.escapeObjectName(statement.getIndexName(), Index.class)).append(" ");
        }
        buffer.append("(");
        Iterator<AddColumnConfig> iterator = Arrays.asList(statement.getColumns()).iterator();
        while (iterator.hasNext()) {
            AddColumnConfig column = iterator.next();
            buffer.append(database.escapeColumnName(statement.getTableCatalogName(), statement.getTableSchemaName(), statement.getTableName(), column.getName()));
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        buffer.append("ON ");
        buffer.append(database.escapeTableName(statement.getTableCatalogName(), statement.getTableSchemaName(), statement.getTableName()));
        return new Sql[]{new UnparsedSql(buffer.toString(), new DatabaseObject[0])};
    }
}

