/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.exec;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TypeCodec;
import com.dbeaver.ee.cassandra.data.CasContentBytes;
import com.dbeaver.ee.cassandra.data.CasListValue;
import com.dbeaver.ee.cassandra.data.CasMapValue;
import com.dbeaver.ee.cassandra.data.CasSetValue;
import com.dbeaver.ee.cassandra.data.CasTupleValue;
import com.dbeaver.ee.cassandra.data.CasUDTValue;
import com.dbeaver.ee.cassandra.exec.CasBaseStatement;
import com.dbeaver.ee.cassandra.exec.CasQueryTrace;
import com.dbeaver.ee.cassandra.exec.CasSession;
import com.dbeaver.ee.cassandra.model.CasResultSetMetaData;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Iterator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetTrace;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.trace.DBCTrace;
import org.jkiss.dbeaver.model.impl.AbstractResultSet;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.utils.CommonUtils;

public class CasResultSet
extends AbstractResultSet<CasSession, CasBaseStatement>
implements DBCResultSetTrace {
    private final ResultSet resultSet;
    private final Iterator<Row> rowIterator;
    private CasResultSetMetaData metaData;
    private Row curRow;
    private ColumnDefinitions columnDefinitions;
    private long rowCount = 0L;

    public CasResultSet(CasBaseStatement statement, ResultSet resultSet) {
        super((DBCSession)statement.getSession(), (DBCStatement)statement);
        ExecutionInfo executionInfo;
        this.resultSet = resultSet;
        this.rowIterator = resultSet.iterator();
        long offset = statement.getOffset();
        if (offset > 0L) {
            int i = 0;
            while ((long)i < offset && this.rowIterator.hasNext()) {
                this.rowIterator.next();
                ++i;
            }
        }
        if ((executionInfo = resultSet.getExecutionInfo()) != null && !CommonUtils.isEmpty((Collection)executionInfo.getWarnings())) {
            Iterator iterator = executionInfo.getWarnings().iterator();
            while (iterator.hasNext()) {
                String cfr_ignored_0 = (String)iterator.next();
            }
        }
        if (statement.getSession().isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
    }

    public Object getAttributeValue(int index) throws DBCException {
        if (this.curRow == null) {
            throw new DBCException("You have to fetch a row");
        }
        if (this.curRow.isNull(index)) {
            return null;
        }
        DataType type = this.columnDefinitions.getType(index);
        switch (type.getName()) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return this.curRow.getString(index);
            }
            case TINYINT: {
                return this.curRow.getByte(index);
            }
            case SMALLINT: {
                return this.curRow.getShort(index);
            }
            case INT: {
                return this.curRow.getInt(index);
            }
            case BIGINT: {
                return this.curRow.getLong(index);
            }
            case COUNTER: {
                return this.curRow.getLong(index);
            }
            case VARINT: {
                return this.curRow.getVarint(index);
            }
            case DECIMAL: {
                return this.curRow.getDecimal(index);
            }
            case FLOAT: {
                return Float.valueOf(this.curRow.getFloat(index));
            }
            case DOUBLE: {
                return this.curRow.getDouble(index);
            }
            case BOOLEAN: {
                return this.curRow.getBool(index);
            }
            case DATE: {
                return this.curRow.getDate(index);
            }
            case TIME: {
                return this.curRow.getTime(index);
            }
            case TIMESTAMP: {
                return this.curRow.getTimestamp(index);
            }
            case UUID: 
            case TIMEUUID: {
                return this.curRow.getUUID(index);
            }
            case INET: {
                return this.curRow.getInet(index);
            }
            case MAP: {
                return new CasMapValue(((CasBaseStatement)this.statement).getSession().getDataSource(), this.columnDefinitions.getKeyspace(index), this.curRow.getMap(index, CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(0)), CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(1))), type);
            }
            case LIST: {
                return new CasListValue(((CasBaseStatement)this.statement).getSession().getProgressMonitor(), ((CasBaseStatement)this.statement).getSession().getDataSource(), this.columnDefinitions.getKeyspace(index), this.curRow.getList(index, CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(0))), type);
            }
            case SET: {
                return new CasSetValue(((CasBaseStatement)this.statement).getSession().getDataSource(), this.columnDefinitions.getKeyspace(index), this.curRow.getSet(index, CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(0))), type);
            }
            case TUPLE: {
                return new CasTupleValue(((CasBaseStatement)this.statement).getSession().getDataSource(), this.columnDefinitions.getKeyspace(index), this.curRow.getTupleValue(index));
            }
            case UDT: {
                return new CasUDTValue(((CasBaseStatement)this.statement).getSession().getDataSource(), this.columnDefinitions.getKeyspace(index), this.curRow.getUDTValue(index));
            }
        }
        return new CasContentBytes(((CasBaseStatement)this.statement).getSession().getDataSource(), this.curRow.getBytes(index));
    }

    public static TypeToken<Object> getClassFromType(DataType dataType) {
        TypeCodec codec = CodecRegistry.DEFAULT_INSTANCE.codecFor(dataType);
        if (codec == null) {
            return TypeToken.of(Object.class);
        }
        return codec.getJavaType();
    }

    public Object getAttributeValue(String name) throws DBCException {
        if (this.curRow == null) {
            throw new DBCException("You have to fetch a row");
        }
        if (this.curRow.isNull(name)) {
            return null;
        }
        DataType type = this.columnDefinitions.getType(name);
        switch (type.getName()) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return this.curRow.getString(name);
            }
            case TINYINT: {
                return this.curRow.getByte(name);
            }
            case SMALLINT: {
                return this.curRow.getShort(name);
            }
            case INT: {
                return this.curRow.getInt(name);
            }
            case BIGINT: {
                return this.curRow.getLong(name);
            }
            case COUNTER: {
                return this.curRow.getLong(name);
            }
            case VARINT: {
                return this.curRow.getVarint(name);
            }
            case DECIMAL: {
                return this.curRow.getDecimal(name);
            }
            case FLOAT: {
                return Float.valueOf(this.curRow.getFloat(name));
            }
            case DOUBLE: {
                return this.curRow.getDouble(name);
            }
            case BOOLEAN: {
                return this.curRow.getBool(name);
            }
            case TIME: {
                return this.curRow.getTime(name);
            }
            case DATE: {
                return this.curRow.getDate(name);
            }
            case TIMESTAMP: {
                return this.curRow.getTimestamp(name);
            }
            case UUID: 
            case TIMEUUID: {
                return this.curRow.getUUID(name);
            }
            case INET: {
                return this.curRow.getInet(name);
            }
            case MAP: {
                return this.curRow.getMap(name, CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(0)), CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(1)));
            }
            case LIST: {
                return this.curRow.getList(name, CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(0)));
            }
            case SET: {
                return this.curRow.getSet(name, CasResultSet.getClassFromType((DataType)type.getTypeArguments().get(0)));
            }
            case TUPLE: {
                return this.curRow.getTupleValue(name);
            }
            case UDT: {
                return this.curRow.getUDTValue(name);
            }
        }
        return this.curRow.getBytes(name);
    }

    public boolean nextRow() throws DBCException {
        if (!this.rowIterator.hasNext()) {
            this.curRow = null;
            this.columnDefinitions = null;
            return false;
        }
        this.curRow = this.rowIterator.next();
        this.columnDefinitions = this.curRow.getColumnDefinitions();
        ++this.rowCount;
        return true;
    }

    public boolean moveTo(int position) throws DBCException {
        return false;
    }

    @NotNull
    public CasResultSetMetaData getMeta() throws DBCException {
        if (this.metaData == null) {
            this.metaData = new CasResultSetMetaData((CasBaseStatement)this.statement, this.resultSet);
        }
        return this.metaData;
    }

    public void close() {
        if (((CasBaseStatement)this.statement).getSession().isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetClose((DBCResultSet)this, this.rowCount);
        }
    }

    public DBCTrace getExecutionTrace() {
        return new CasQueryTrace(this.resultSet.getExecutionInfo());
    }
}

