/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.data.handlers;

import com.datastax.driver.core.DataType;
import com.dbeaver.ee.cassandra.data.CasMapValue;
import com.dbeaver.ee.cassandra.data.handlers.CasComplexValueHandler;
import com.dbeaver.ee.cassandra.exec.CasPreparedStatement;
import com.dbeaver.ee.cassandra.exec.CasSession;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import com.dbeaver.ee.cassandra.model.CasTableColumn;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasMapValueHandler
extends CasComplexValueHandler {
    private static final Log log = Log.getLog(CasMapValueHandler.class);
    public static final CasMapValueHandler INSTANCE = new CasMapValueHandler();

    @NotNull
    public Class<CasMapValue> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return CasMapValue.class;
    }

    public CasMapValue getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        CasDataSource dataSource = (CasDataSource)session.getDataSource();
        if (object == null) {
            DataType.CollectionType dt = DataType.map((DataType)DataType.text(), (DataType)DataType.text());
            if (type instanceof CasTableColumn) {
                dt = ((CasTableColumn)type).getMetadata().getType();
            }
            return new CasMapValue(dataSource, dataSource.getSelectedKeyspaceName(), null, (DataType)dt);
        }
        if (object instanceof CasMapValue) {
            return copy ? new CasMapValue((CasMapValue)object) : (CasMapValue)object;
        }
        throw new DBCException("Unsupported map type: " + object.getClass().getName());
    }

    @Override
    protected void bindParameter(CasSession session, CasPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
        statement.getBoundStatement().setMap(paramIndex, ((CasMapValue)value).makeMap());
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof CasMapValue) {
            try {
                CasMapValue map = (CasMapValue)value;
                StringBuilder str = new StringBuilder();
                str.append('{');
                int i = 0;
                while (i < map.getItemCount()) {
                    if (i > 0) {
                        str.append(',');
                    }
                    DBDComposite item = map.getItem(i);
                    DBSAttributeBase[] attrs = item.getAttributes();
                    str.append('\'').append(item.getAttributeValue(attrs[0])).append('\'').append(':');
                    DBDValueHandler valueHandler = DBUtils.findValueHandler((DBPDataSource)map.getDataSource(), (DBSTypedObject)attrs[1]);
                    str.append('\'').append(valueHandler.getValueDisplayString((DBSTypedObject)attrs[1], item.getAttributeValue(attrs[1]), DBDDisplayFormat.NATIVE)).append('\'');
                    ++i;
                }
                str.append('}');
                return str.toString();
            }
            catch (DBCException e) {
                log.error((Object)e);
                return e.getMessage();
            }
        }
        return super.getValueDisplayString(column, value, format);
    }
}

