/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui.wizard;

import com.dbeaver.ee.scmp.model.CMPCompareEngine;
import com.dbeaver.ee.scmp.model.CMPInput;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.model.CMPResult;
import com.dbeaver.ee.scmp.model.CMPUtils;
import com.dbeaver.ee.scmp.registry.SCMPDiffEngineDescriptor;
import com.dbeaver.ee.scmp.registry.SCMPEngineRegistry;
import com.dbeaver.ee.scmp.ui.wizard.SchemaComparePageDiff;
import com.dbeaver.ee.scmp.ui.wizard.SchemaComparePageInput;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class SchemaCompareWizard
extends Wizard
implements IExportWizard {
    private static final Log log = Log.getLog(SchemaCompareWizard.class);
    private IWorkbenchPart workbenchPart;
    private IStructuredSelection selection;
    private boolean migrateWizard;
    private final CMPInput sourceInput = new CMPInput();
    private final CMPInput targetInput = new CMPInput();
    private CMPOptions options;

    public SchemaCompareWizard(IWorkbenchPart workbenchPart, IStructuredSelection selection, boolean migrateWizard) {
        this.setWindowTitle(migrateWizard ? "Schema Migration" : "Schema Compare");
        this.workbenchPart = workbenchPart;
        this.selection = selection;
        this.migrateWizard = migrateWizard;
        this.options = new CMPOptions(this.sourceInput, this.targetInput);
        try {
            this.fillInputsFromSelection();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        this.setNeedsProgressMonitor(true);
    }

    private void fillInputsFromSelection() {
        if (this.selection == null || this.selection.isEmpty()) {
            return;
        }
        LinkedHashMap<DBPDataSourceContainer, Set> dataSourceObjectMap = new LinkedHashMap<DBPDataSourceContainer, Set>();
        LinkedHashMap<DBSObjectContainer, Set> containerObjectMap = new LinkedHashMap<DBSObjectContainer, Set>();
        Object[] objectArray = this.selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof DBNDatabaseNode) {
                DBPDataSourceContainer dataSourceContainer;
                DBSObject object = ((DBNDatabaseNode)element).getObject();
                Object object2 = object instanceof DBPDataSourceContainer ? (DBPDataSourceContainer)object : (dataSourceContainer = object.getDataSource() == null ? null : object.getDataSource().getContainer());
                if (dataSourceContainer != null) {
                    Set dsObjectSet = dataSourceObjectMap.computeIfAbsent(dataSourceContainer, dataSourceContainer1 -> new LinkedHashSet());
                    dsObjectSet.add(object);
                    DBSObjectContainer container = null;
                    if (object instanceof DBSObjectContainer) {
                        container = (DBSObjectContainer)object;
                    } else if (object.getParentObject() instanceof DBSObjectContainer) {
                        container = (DBSObjectContainer)object.getParentObject();
                    }
                    if (container != null) {
                        Set contObjectSet = containerObjectMap.computeIfAbsent(container, dataSourceContainer1 -> new LinkedHashSet());
                        contObjectSet.add(object);
                    }
                }
            }
            ++n2;
        }
        Iterator dsIterator = dataSourceObjectMap.keySet().iterator();
        this.sourceInput.setDataSourceContainer(dsIterator.hasNext() ? (DBPDataSourceContainer)dsIterator.next() : null);
        this.targetInput.setDataSourceContainer(dsIterator.hasNext() ? (DBPDataSourceContainer)dsIterator.next() : null);
        if (this.sourceInput.getDataSourceContainer() != null && this.targetInput.getDataSourceContainer() != null) {
            this.sourceInput.setInputObjects(new ArrayList((Collection)dataSourceObjectMap.get(this.sourceInput.getDataSourceContainer())));
            this.targetInput.setInputObjects(new ArrayList((Collection)dataSourceObjectMap.get(this.targetInput.getDataSourceContainer())));
        } else if (this.sourceInput.getDataSourceContainer() != null) {
            this.targetInput.setDataSourceContainer(this.sourceInput.getDataSourceContainer());
            if (containerObjectMap.size() > 1) {
                Iterator objectIterator = containerObjectMap.values().iterator();
                this.sourceInput.setInputObjects(new ArrayList((Collection)objectIterator.next()));
                this.targetInput.setInputObjects(new ArrayList((Collection)objectIterator.next()));
            } else if (!containerObjectMap.isEmpty()) {
                Set allObjects = (Set)containerObjectMap.values().iterator().next();
                Iterator objectIterator = allObjects.iterator();
                this.sourceInput.setInputObjects((List)(objectIterator.hasNext() ? new ArrayList<DBSObject>(Collections.singletonList((DBSObject)objectIterator.next())) : new ArrayList()));
                this.targetInput.setInputObjects((List)(objectIterator.hasNext() ? new ArrayList<DBSObject>(Collections.singletonList((DBSObject)objectIterator.next())) : new ArrayList()));
            }
        }
    }

    public IWorkbenchPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public boolean isMigrateWizard() {
        return this.migrateWizard;
    }

    public boolean needsPreviousAndNextButtons() {
        return false;
    }

    public boolean performFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage instanceof SchemaComparePageInput) {
            if (this.performCompare()) {
                this.getContainer().showPage((IWizardPage)this.getDiffResultPage());
            }
            return false;
        }
        this.getContainer().showPage((IWizardPage)this.getInputConfigPage());
        return false;
    }

    private SchemaComparePageInput getInputConfigPage() {
        return (SchemaComparePageInput)this.getPages()[0];
    }

    private SchemaComparePageDiff getDiffResultPage() {
        return (SchemaComparePageDiff)this.getPages()[1];
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.addPage((IWizardPage)new SchemaComparePageInput(this));
        this.addPage((IWizardPage)new SchemaComparePageDiff(this));
    }

    public IProject getProject() {
        return DBWorkbench.getPlatform().getProjectManager().getActiveProject();
    }

    public CMPInput getSourceInput() {
        return this.sourceInput;
    }

    public CMPInput getTargetInput() {
        return this.targetInput;
    }

    public CMPOptions getOptions() {
        return this.options;
    }

    public boolean isValidMapping() {
        List sourceContainers = CMPUtils.getContainers((Collection)this.sourceInput.getInputObjects(), DBSObjectContainer.class, (boolean)false);
        List targetContainers = CMPUtils.getContainers((Collection)this.targetInput.getInputObjects(), DBSObjectContainer.class, (boolean)false);
        if (sourceContainers.isEmpty() || targetContainers.isEmpty()) {
            return false;
        }
        return sourceContainers.size() == targetContainers.size();
    }

    public boolean isSrcSameAsTarget() {
        if (this.sourceInput == null || this.targetInput == null) {
            return false;
        }
        if (this.sourceInput.getDataSourceContainer() != this.targetInput.getDataSourceContainer()) {
            return false;
        }
        ArrayList targets = new ArrayList(this.targetInput.getInputObjects());
        for (DBSObject o : this.sourceInput.getInputObjects()) {
            int idx = targets.indexOf(o);
            if (idx < 0) {
                return false;
            }
            targets.remove(idx);
        }
        return targets.size() <= 0;
    }

    private boolean performCompare() {
        try {
            this.getContainer().run(true, true, monitor -> {
                try {
                    this.performCompare((DBRProgressMonitor)new DefaultProgressMonitor(monitor));
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
            this.getInputConfigPage().setErrorMessage(null);
            return true;
        }
        catch (InvocationTargetException e) {
            this.getInputConfigPage().setErrorMessage(e.getTargetException().getMessage());
            DBWorkbench.getPlatformUI().showError(String.valueOf(this.getWindowTitle()) + " Failed", "Error performing " + this.getWindowTitle(), (Throwable)e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private void performCompare(DBRProgressMonitor monitor) throws DBException {
        SCMPDiffEngineDescriptor diffEngineDescriptor = null;
        if (!CommonUtils.isEmpty((String)this.options.getDiffEngineId()) && (diffEngineDescriptor = SCMPEngineRegistry.getInstance().getDiffEngine(this.options.getDiffEngineId())) == null) {
            log.warn((Object)("Diff engine '" + this.options.getDiffEngineId() + "' not found. Use default."));
        }
        if (diffEngineDescriptor == null) {
            diffEngineDescriptor = SCMPEngineRegistry.getInstance().getDefaultDiffEngine();
        }
        monitor.beginTask("Perform diff using engine " + diffEngineDescriptor.getLabel() + "...", 10);
        monitor.subTask("Prepare");
        try {
            CMPCompareEngine diffEngine = diffEngineDescriptor.createEngine();
            CMPResult cmpResult = diffEngine.compareObjects(monitor, this.options);
            this.getDiffResultPage().populateResults(this.options, cmpResult);
        }
        finally {
            monitor.done();
        }
    }
}

