/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.MenuCreator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.gis.IGeometryValueEditor;
import org.jkiss.dbeaver.ui.gis.panel.GISEditorUtils;
import org.jkiss.dbeaver.ui.gis.panel.GISViewerConfigurationDialog;
import org.jkiss.dbeaver.ui.gis.panel.SelectSRIDDialog;
import org.jkiss.dbeaver.ui.gis.panel.SetCRSAction;

class SelectCRSAction
extends Action {
    private IGeometryValueEditor valueEditor;

    public SelectCRSAction(IGeometryValueEditor valueEditor) {
        super("EPSG:" + valueEditor.getValueSRID(), 4);
        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CHART_LINE));
        this.valueEditor = valueEditor;
    }

    public void run() {
        SelectSRIDDialog manageCRSDialog = new SelectSRIDDialog(UIUtils.getActiveWorkbenchShell(), this.valueEditor.getValueSRID());
        if (manageCRSDialog.open() == 0) {
            this.valueEditor.setValueSRID(manageCRSDialog.getSelectedSRID());
        }
    }

    public IMenuCreator getMenuCreator() {
        return new MenuCreator(control -> {
            MenuManager menuManager = new MenuManager();
            menuManager.setRemoveAllWhenShown(true);
            menuManager.addMenuListener(manager -> {
                menuManager.add((IAction)new SetCRSAction(this.valueEditor, 4326));
                menuManager.add((IAction)new SetCRSAction(this.valueEditor, 3857));
                menuManager.add((IContributionItem)new Separator());
                List<Integer> recentSRIDs = GISEditorUtils.getRecentSRIDs();
                if (!recentSRIDs.isEmpty()) {
                    for (Integer recentSRID : recentSRIDs) {
                        menuManager.add((IAction)new SetCRSAction(this.valueEditor, recentSRID));
                    }
                    menuManager.add((IContributionItem)new Separator());
                }
                menuManager.add((IAction)new Action("Other ..."){

                    public void run() {
                        SelectCRSAction.this.run();
                    }
                });
                menuManager.add((IAction)new Action("Configuration ..."){

                    public void run() {
                        new GISViewerConfigurationDialog(SelectCRSAction.this.valueEditor.getEditorControl().getShell()).open();
                    }
                });
            });
            return menuManager;
        });
    }
}

