/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.views;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.net.SSLConfiguratorTrustStoreUI;
import org.jkiss.utils.CommonUtils;

public class MongoSSLConfigurator
extends SSLConfiguratorTrustStoreUI {
    private Button allowInvalidHostName;
    private Button useSelfSignedCertificate;

    public void createControl(final Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        this.createTrustStoreConfigGroup(composite);
        Group certGroup = UIUtils.createControlGroup((Composite)composite, (String)"Settings", (int)1, (int)768, (int)-1);
        this.allowInvalidHostName = UIUtils.createCheckbox((Composite)certGroup, (String)"Allow invalid host name", (String)"", (boolean)false, (int)1);
        this.useSelfSignedCertificate = UIUtils.createCheckbox((Composite)certGroup, (String)"Use self signed certificate (non-secure)", (String)"", (boolean)false, (int)1);
        this.useSelfSignedCertificate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MongoSSLConfigurator.this.useSelfSignedCertificate.getSelection() && !UIUtils.confirmAction((Shell)parent.getShell(), (String)"Security warning", (String)"Using self-signed certificates is very non-secure.\nUse this option on your own risk.\nAre you sure you want to disable SSL certificate checking?", (int)8)) {
                    MongoSSLConfigurator.this.useSelfSignedCertificate.setSelection(false);
                }
            }
        });
    }

    protected boolean useCACertificate() {
        return true;
    }

    public void loadSettings(DBWHandlerConfiguration configuration) {
        super.loadSettings(configuration);
        this.allowInvalidHostName.setSelection(CommonUtils.getBoolean((String)((String)configuration.getProperties().get("sslInvalidHostNameAllowed"))));
        this.useSelfSignedCertificate.setSelection(CommonUtils.getBoolean((String)((String)configuration.getProperties().get("ssl.self-signed-cert"))));
    }

    public void saveSettings(DBWHandlerConfiguration configuration) {
        super.saveSettings(configuration);
        configuration.getProperties().put("sslInvalidHostNameAllowed", String.valueOf(this.allowInvalidHostName.getSelection()));
        configuration.getProperties().put("ssl.self-signed-cert", String.valueOf(this.useSelfSignedCertificate.getSelection()));
    }
}

