/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.handlers;

import com.dbeaver.ee.vqb.internal.ui.VQBUIActivator;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.handlers.VQBAbstractHandler;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;

public class OpenQueryBuilderHandler
extends AbstractHandler
implements IElementUpdater {
    private static final Log log = Log.getLog(OpenQueryBuilderHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (activeEditor instanceof SQLEditor) {
            SQLEditor sqlEditor = (SQLEditor)activeEditor;
            if (sqlEditor.getExtraPresentationState() == SQLEditorPresentation.ActivationType.HIDDEN) {
                boolean isNew = sqlEditor.getExtraPresentation() == null;
                sqlEditor.showExtraPresentation(true, true);
                SQLEditorPresentation extraPresentation = sqlEditor.getExtraPresentation();
                if (!isNew && extraPresentation instanceof VQBEditorPresentation) {
                    ((VQBEditorPresentation)extraPresentation).parseActiveQuery();
                }
            } else {
                SQLEditorPresentation extraPresentation = sqlEditor.getExtraPresentation();
                if (extraPresentation instanceof VQBEditorPresentation && ((VQBEditorPresentation)extraPresentation).isDirty()) {
                    int result;
                    ConfirmationDialog confirmationDialog = null;
                    if (VQBUIActivator.getDefault().getPreferences().getBoolean("vqb.save.query.always")) {
                        result = 2;
                    } else {
                        confirmationDialog = new ConfirmationDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), "Query Save", null, "You have unsaved changes in your active query.\nDo you want to save it back to SQL editor?", 4, ConfirmationDialog.getButtonLabels((int)6), ConfirmationDialog.getDefaultIndex((int)6, (int)4), "Save always", false);
                        result = confirmationDialog.open();
                    }
                    if (result == 1) {
                        return null;
                    }
                    if (result == 2) {
                        if (confirmationDialog != null && confirmationDialog.getToggleState()) {
                            VQBUIActivator.getDefault().getPreferences().setValue("vqb.save.query.always", true);
                        }
                        ((VQBEditorPresentation)extraPresentation).doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                }
                sqlEditor.showExtraPresentation(false, false);
            }
        }
        VQBAbstractHandler.updateEditorCommandStates();
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)element.getServiceLocator().getService(IWorkbenchWindow.class);
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return;
        }
        IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor instanceof SQLEditor) {
            element.setChecked(((SQLEditor)activeEditor).getExtraPresentationState() != SQLEditorPresentation.ActivationType.HIDDEN);
        }
    }
}

