/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor;

import com.dbeaver.ee.vqb.ui.builder.VQBQueryInfo;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPart;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBEditorQueryPanel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISaveablePart;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListener;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListenerDefault;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;

public class VQBEditorPresentation
implements SQLEditorPresentation,
ISaveablePart {
    private static final Log log = Log.getLog(VQBEditorPresentation.class);
    private SQLEditor sqlEditor;
    private VQBEditorPart vqbEditor;
    private SQLListener sqlListener;

    public SQLEditor getSQLEditor() {
        return this.sqlEditor;
    }

    public VQBEditorPart getVQBEditor() {
        return this.vqbEditor;
    }

    public void createPresentation(Composite parent, SQLEditor editor) {
        this.sqlEditor = editor;
        this.sqlListener = new SQLListener();
        this.sqlEditor.addListener((SQLEditorListener)this.sqlListener);
        this.vqbEditor = new VQBEditorPart(this);
        try {
            this.vqbEditor.init(editor.getEditorSite(), editor.getEditorInput());
            this.vqbEditor.createPartControl(parent);
            this.parseActiveQuery();
        }
        catch (Exception e) {
            log.error((Object)"Error creating ERD panel", (Throwable)e);
        }
    }

    public void dispose() {
        this.vqbEditor.dispose();
        this.sqlEditor.removeListener((SQLEditorListener)this.sqlListener);
    }

    public void parseActiveQuery() {
        SQLScriptElement scriptElement = this.sqlEditor.extractActiveQuery();
        if (scriptElement == null) {
            ITextSelection selection = (ITextSelection)this.sqlEditor.getSelectionProvider().getSelection();
            SQLQuery emptyQuery = new SQLQuery(this.sqlEditor.getDataSource(), "");
            emptyQuery.setOffset(selection.getOffset());
            emptyQuery.setLength(selection.getLength());
            this.vqbEditor.loadQuery(emptyQuery);
        } else if (scriptElement instanceof SQLQuery) {
            this.vqbEditor.loadQuery((SQLQuery)scriptElement);
        }
        this.refreshStatement();
    }

    @Nullable
    public VQBEditorQueryPanel getQueryPanel() {
        VQBEditorQueryPanel panel = (VQBEditorQueryPanel)this.sqlEditor.getExtraPresentationPanel(VQBEditorQueryPanel.class);
        if (panel == null) {
            panel = (VQBEditorQueryPanel)this.sqlEditor.showPresentationPanel("vqb_settings");
        }
        return panel;
    }

    void refreshStatement() {
        VQBEditorQueryPanel queryPanel = this.getQueryPanel();
        if (queryPanel != null) {
            queryPanel.refreshFromStatement(true);
        }
        this.sqlEditor.updateDirtyFlag();
    }

    public void doSave(IProgressMonitor monitor) {
        if (EditorUtils.isInAutoSaveJob()) {
            return;
        }
        if (!this.updateQueryInEditor()) {
            monitor.setCanceled(true);
        }
    }

    private boolean updateQueryInEditor() {
        if (!this.vqbEditor.isDirty()) {
            return true;
        }
        VQBQueryInfo queryInfo = this.vqbEditor.getQueryInfo();
        SQLQuery query = queryInfo.getQuery();
        try {
            String newQueryText = String.valueOf(query.getText()) + "\n";
            this.sqlEditor.getDocument().replace(query.getOffset(), query.getLength(), newQueryText);
            query.setLength(newQueryText.length());
            this.sqlEditor.getSelectionProvider().setSelection((ISelection)new TextSelection(query.getOffset(), 0));
            this.vqbEditor.resetDirtyFlag();
            return true;
        }
        catch (BadLocationException e) {
            log.error((Object)"Error updating query in SQL editor", (Throwable)e);
            return false;
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.vqbEditor.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    private class SQLListener
    extends SQLEditorListenerDefault {
        private SQLListener() {
        }

        public void beforeQueryExecute(boolean script, boolean newTabs) {
            VQBEditorPresentation.this.updateQueryInEditor();
        }

        public void beforeQueryPlanExplain() {
            VQBEditorPresentation.this.updateQueryInEditor();
        }
    }
}

