/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MinimumMemoryMap<K, V>
implements Map<K, V> {
    ArrayList<K> keys;
    ArrayList<V> values;
    private KeyHashCodeComparator keyHashCodeComparator = new KeyHashCodeComparator();

    public MinimumMemoryMap() {
        this.keys = new ArrayList();
        this.values = new ArrayList();
    }

    public MinimumMemoryMap(int initialSize) {
        this.keys = new ArrayList(initialSize);
        this.values = new ArrayList(initialSize);
    }

    public MinimumMemoryMap(Map<K, V> otherMap) {
        this.keys = new ArrayList();
        this.values = new ArrayList();
        this.putAll(otherMap);
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    private int binarySearch(ArrayList<K> keys, K key) {
        int index = Collections.binarySearch(keys, key, this.keyHashCodeComparator);
        if (index >= 0) {
            if (keys.get(index).equals(key)) {
                return index;
            }
            for (int prevIndex = index - 1; prevIndex >= 0; --prevIndex) {
                K prevKey = keys.get(prevIndex);
                if (key.hashCode() != prevKey.hashCode()) break;
                if (!prevKey.equals(key)) continue;
                return prevIndex;
            }
            for (int nextIndex = index + 1; nextIndex < keys.size(); ++nextIndex) {
                K nextKey = keys.get(nextIndex);
                if (key.hashCode() != nextKey.hashCode()) break;
                if (!nextKey.equals(key)) continue;
                return nextIndex;
            }
            ++index;
            index = -index;
        }
        return index;
    }

    @Override
    public boolean containsKey(Object key) {
        int index = this.binarySearch(this.keys, key);
        return index >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public V get(Object key) {
        int index = this.binarySearch(this.keys, key);
        if (index >= 0) {
            return this.values.get(index);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        V previousValue = null;
        int index = this.binarySearch(this.keys, key);
        if (index >= 0) {
            previousValue = this.values.get(index);
            this.values.set(index, value);
        } else {
            index = -index;
            this.keys.add(--index, key);
            this.values.add(index, value);
        }
        return previousValue;
    }

    @Override
    public V remove(Object key) {
        V removedValue = null;
        int index = this.binarySearch(this.keys, key);
        if (index >= 0) {
            removedValue = this.values.get(index);
            this.keys.remove(index);
            this.values.remove(index);
        }
        return removedValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        int requiredCapacity = this.size() + m.size();
        this.keys.ensureCapacity(requiredCapacity);
        this.values.ensureCapacity(requiredCapacity);
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<K> keySet() {
        return new HashSet<K>(this.keys);
    }

    @Override
    public Collection<V> values() {
        return new ArrayList<V>(this.values);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        int size = this.keys.size();
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>(size);
        for (int index = 0; index < size; ++index) {
            entrySet.add(new AbstractMap.SimpleEntry<K, V>(this.keys.get(index), this.values.get(index)));
        }
        return entrySet;
    }

    public String toString() {
        return this.entrySet().toString();
    }

    private class KeyHashCodeComparator
    implements Comparator<K> {
        private KeyHashCodeComparator() {
        }

        @Override
        public int compare(K key1, K key2) {
            int hashCode2;
            int hashCode1 = key1 != null ? key1.hashCode() : 0;
            int n = hashCode2 = key2 != null ? key2.hashCode() : 0;
            if (hashCode1 == hashCode2) {
                return 0;
            }
            if (hashCode1 < hashCode2) {
                return -1;
            }
            return 1;
        }
    }
}

