/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.relique.io.DataReader;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.AsteriskExpression;
import org.relique.jdbc.csv.ColumnName;
import org.relique.jdbc.csv.CsvConnection;
import org.relique.jdbc.csv.CsvReader;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.CsvResultSetMetaData;
import org.relique.jdbc.csv.CsvStatement;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.MinimumMemoryMap;
import org.relique.jdbc.csv.NumericConstant;
import org.relique.jdbc.csv.StringConverter;
import org.relique.jdbc.csv.SubQueryExpression;

public class CsvResultSet
implements ResultSet {
    private ResultSetMetaData resultSetMetaData;
    private CsvStatement statement;
    private int resultSetType = 1005;
    private DataReader reader;
    private String tableName;
    private int lastIndexRead = -1;
    private LogicalExpression whereClause;
    private List<Expression> groupByColumns;
    private List<Expression> distinctColumns;
    private LogicalExpression havingClause;
    private List<Object[]> orderByColumns;
    private List<Object[]> queryEnvironment;
    private List<AggregateFunction> aggregateFunctions;
    private Set<ArrayList<Object>> distinctValues;
    private Map<String, Object> parentObjectEnvironment;
    private Map<String, Object> recordEnvironment;
    private List<String> usedColumns;
    private StringConverter converter;
    private ArrayList<Map<String, Object>> bufferedRecordEnvironments = null;
    private int currentRow;
    private boolean hitTail = false;
    private boolean nextResult = true;
    private int maxRows;
    private int fetchSize;
    private int fetchDirection;
    private int limit;
    private boolean isClosed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CsvResultSet(CsvStatement statement, DataReader reader, String tableName, List<Object[]> queryEnvironment, boolean isDistinct, int resultSetType, LogicalExpression whereClause, List<Expression> groupByColumns, LogicalExpression havingClause, List<Object[]> orderByColumns, int sqlLimit, int sqlOffset, String columnTypes, int skipLeadingLines, Map<String, Object> parentObjectEnvironment) throws ClassNotFoundException, SQLException {
        Expression expr;
        int i;
        this.statement = statement;
        this.maxRows = statement.getMaxRows();
        this.fetchSize = statement.getFetchSize();
        this.fetchDirection = statement.getFetchDirection();
        this.limit = sqlLimit;
        this.resultSetType = resultSetType;
        this.reader = reader;
        this.tableName = tableName;
        this.queryEnvironment = new ArrayList<Object[]>(queryEnvironment);
        this.aggregateFunctions = new ArrayList<AggregateFunction>();
        this.whereClause = whereClause;
        this.groupByColumns = groupByColumns != null ? new ArrayList<Expression>(groupByColumns) : null;
        this.havingClause = havingClause;
        this.orderByColumns = orderByColumns != null ? new ArrayList<Object[]>(orderByColumns) : null;
        if (isDistinct) {
            this.distinctValues = new HashSet<ArrayList<Object>>();
        }
        this.parentObjectEnvironment = parentObjectEnvironment;
        String timeFormat = ((CsvConnection)statement.getConnection()).getTimeFormat();
        String dateFormat = ((CsvConnection)statement.getConnection()).getDateFormat();
        String timestampFormat = ((CsvConnection)statement.getConnection()).getTimestampFormat();
        String timeZone = ((CsvConnection)statement.getConnection()).getTimeZoneName();
        Locale locale = ((CsvConnection)statement.getConnection()).getLocale();
        this.converter = new StringConverter(dateFormat, timeFormat, timestampFormat, timeZone, locale);
        if (reader instanceof CsvReader) {
            ((CsvReader)reader).setConverter(this.converter);
            if (!"".equals(columnTypes)) {
                ((CsvReader)reader).setColumnTypes(columnTypes);
            }
        }
        String[] columnNames = reader.getColumnNames();
        String tableAlias = reader.getTableAlias();
        HashSet<String> allReaderColumns = new HashSet<String>();
        for (i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i].toUpperCase();
            allReaderColumns.add(columnName);
            if (tableName != null) {
                allReaderColumns.add(tableName.toUpperCase() + "." + columnName);
            }
            if (tableAlias == null) continue;
            allReaderColumns.add(tableAlias + "." + columnName);
        }
        this.usedColumns = whereClause != null ? new LinkedList<String>(whereClause.usedColumns(allReaderColumns)) : new LinkedList<String>();
        if (this.resultSetType != 1003 && this.resultSetType != 1004 && this.resultSetType != 1005) {
            throw new SQLException(CsvResources.getString("invalidResultSetType") + ": " + this.resultSetType);
        }
        for (i = 0; i < this.queryEnvironment.size(); ++i) {
            Object[] o2 = this.queryEnvironment.get(i);
            if (!(o2[1] instanceof AsteriskExpression)) continue;
            AsteriskExpression asteriskExpression = (AsteriskExpression)o2[1];
            String asterisk = asteriskExpression.toString();
            if (!(asterisk.equals("*") || tableAlias != null && asterisk.equalsIgnoreCase(tableAlias + ".*"))) {
                throw new SQLException(CsvResources.getString("invalidColumnName") + ": " + asterisk);
            }
            this.queryEnvironment.remove(i);
            for (int j = 0; j < columnNames.length; ++j) {
                this.queryEnvironment.add(i + j, new Object[]{columnNames[j], new ColumnName(columnNames[j])});
            }
        }
        if (this.groupByColumns != null) {
            for (i = 0; i < this.groupByColumns.size(); ++i) {
                Expression expression = this.groupByColumns.get(i);
                if (!(expression instanceof NumericConstant)) continue;
                NumericConstant n = (NumericConstant)expression;
                if (!(n.value instanceof Integer)) {
                    throw new SQLException(CsvResources.getString("invalidGroupBy") + ": " + n);
                }
                int index = n.value.intValue();
                if (--index < 0 || index >= this.queryEnvironment.size()) {
                    throw new SQLException(CsvResources.getString("invalidGroupBy") + ": " + (index + 1));
                }
                Object[] q = this.queryEnvironment.get(index);
                this.groupByColumns.set(i, (Expression)q[1]);
            }
        }
        if (this.groupByColumns != null) {
            for (Expression expr2 : this.groupByColumns) {
                this.usedColumns.addAll(expr2.usedColumns(allReaderColumns));
            }
            if (havingClause != null) {
                this.usedColumns.addAll(havingClause.usedColumns(allReaderColumns));
            }
        }
        if (this.orderByColumns != null) {
            for (Object[] o : this.orderByColumns) {
                Expression expression = (Expression)o[1];
                if (!(expression instanceof NumericConstant)) continue;
                NumericConstant n = (NumericConstant)expression;
                if (!(n.value instanceof Integer)) {
                    throw new SQLException(CsvResources.getString("invalidOrderBy") + ": " + n);
                }
                int index = n.value.intValue();
                if (--index < 0 || index >= this.queryEnvironment.size()) {
                    throw new SQLException(CsvResources.getString("invalidOrderBy") + ": " + (index + 1));
                }
                Object[] objectArray = this.queryEnvironment.get(index);
                o[1] = objectArray[1];
            }
        }
        if (this.orderByColumns != null) {
            for (Object[] o : this.orderByColumns) {
                expr = (Expression)o[1];
                this.usedColumns.addAll(expr.usedColumns(allReaderColumns));
            }
        }
        for (int i2 = 0; i2 < this.queryEnvironment.size(); ++i2) {
            Object[] o;
            o = this.queryEnvironment.get(i2);
            expr = (Expression)o[1];
            if (expr instanceof SubQueryExpression) continue;
            List<AggregateFunction> exprAggregateFunctions = expr.aggregateFunctions();
            this.aggregateFunctions.addAll(exprAggregateFunctions);
            for (AggregateFunction aggregateFunction : exprAggregateFunctions) {
                this.usedColumns.addAll(aggregateFunction.aggregateColumns(allReaderColumns));
            }
        }
        if (this.aggregateFunctions.size() > 0 && this.groupByColumns == null) {
            LinkedList<String> allUsedColumns = new LinkedList<String>();
            for (int i3 = 0; i3 < this.queryEnvironment.size(); ++i3) {
                Object[] o3 = this.queryEnvironment.get(i3);
                if (o3[1] == null) continue;
                allUsedColumns.addAll(((Expression)o3[1]).usedColumns(allReaderColumns));
            }
            if (allUsedColumns.size() > 0 && this.aggregateFunctions.size() > 0) {
                throw new SQLException(CsvResources.getString("columnsWithAggregateFunctions"));
            }
        }
        if (whereClause != null && whereClause.aggregateFunctions().size() > 0) {
            throw new SQLException(CsvResources.getString("noAggregateFunctions"));
        }
        if (!((CsvConnection)statement.getConnection()).isIndexedFiles()) {
            for (int i4 = 0; i4 < this.queryEnvironment.size(); ++i4) {
                Object[] o4 = this.queryEnvironment.get(i4);
                if (o4[1] != null && !((expr = (Expression)o4[1]) instanceof SubQueryExpression)) {
                    List<String> exprUsedColumns = expr.usedColumns(allReaderColumns);
                    for (String string : exprUsedColumns) {
                        if (allReaderColumns.contains(string)) continue;
                        throw new SQLException(CsvResources.getString("invalidColumnName") + ": " + string);
                    }
                }
                allReaderColumns.add(o4[0].toString());
            }
        }
        if (!((CsvConnection)statement.getConnection()).isIndexedFiles()) {
            for (String usedColumn : this.usedColumns) {
                if (allReaderColumns.contains(usedColumn) || parentObjectEnvironment.containsKey(usedColumn)) continue;
                throw new SQLException(CsvResources.getString("invalidColumnName") + ": " + usedColumn);
            }
            this.checkGroupBy(allReaderColumns);
            if (this.orderByColumns != null) {
                for (Object[] o5 : this.orderByColumns) {
                    Object copy;
                    expr = (Expression)o5[1];
                    Object exprUsedColumns = new LinkedList<String>(expr.usedColumns(allReaderColumns));
                    if (expr instanceof SubQueryExpression) {
                        copy = new LinkedList();
                        Iterator iterator = exprUsedColumns.iterator();
                        while (iterator.hasNext()) {
                            String usedColumn2 = (String)iterator.next();
                            if (!allReaderColumns.contains(usedColumn2.toUpperCase())) continue;
                            copy.add(usedColumn2);
                        }
                        exprUsedColumns = copy;
                    }
                    copy = exprUsedColumns.iterator();
                    while (copy.hasNext()) {
                        String string = (String)copy.next();
                        if (allReaderColumns.contains(string) || parentObjectEnvironment.containsKey(string)) continue;
                        throw new SQLException(CsvResources.getString("invalidColumnName") + ": " + string);
                    }
                    if (!exprUsedColumns.isEmpty()) continue;
                    throw new SQLException(CsvResources.getString("invalidOrderBy") + ": " + expr.toString());
                }
            }
        }
        if (this.distinctValues != null) {
            for (int i5 = 0; i5 < this.queryEnvironment.size(); ++i5) {
                Object[] o6 = this.queryEnvironment.get(i5);
                expr = (Expression)o6[1];
                this.usedColumns.addAll(expr.usedColumns(allReaderColumns));
            }
        }
        if (this.groupByColumns != null || this.orderByColumns != null || this.aggregateFunctions.size() > 0 || this.isScrollable()) {
            this.bufferedRecordEnvironments = new ArrayList();
            this.currentRow = 0;
        }
        if (this.groupByColumns != null) {
            int savedMaxRows = this.maxRows;
            int savedLimit = this.limit;
            this.maxRows = 0;
            this.limit = -1;
            ArrayList groupOrder = new ArrayList();
            MinimumMemoryMap groups = new MinimumMemoryMap();
            try {
                while (this.next()) {
                    Map<String, Object> objectEnvironment = this.updateRecordEnvironment(true);
                    if (this.converter != null) {
                        objectEnvironment.put("@STRINGCONVERTER", this.converter);
                    }
                    ArrayList<Object> arrayList = new ArrayList<Object>(this.groupByColumns.size());
                    for (Expression expr3 : this.groupByColumns) {
                        arrayList.add(expr3.eval(objectEnvironment));
                    }
                    ArrayList<Map<String, Object>> groupByValues = (ArrayList<Map<String, Object>>)groups.get(arrayList);
                    if (groupByValues == null) {
                        groupByValues = new ArrayList<Map<String, Object>>();
                        groups.put(arrayList, groupByValues);
                        groupOrder.add(arrayList);
                    }
                    groupByValues.add(this.recordEnvironment);
                }
                this.bufferedRecordEnvironments.clear();
                for (ArrayList arrayList : groupOrder) {
                    ArrayList values = (ArrayList)groups.get(arrayList);
                    MinimumMemoryMap<String, Object> firstRow = new MinimumMemoryMap<String, Object>((Map)values.get(0));
                    firstRow.put("@GROUPROWS", values);
                    if (this.havingClause != null && !Boolean.TRUE.equals(this.havingClause.isTrue(firstRow))) continue;
                    this.bufferedRecordEnvironments.add(firstRow);
                }
                if (this.orderByColumns != null) {
                    this.sortRows(sqlOffset);
                }
            }
            finally {
                this.maxRows = savedMaxRows;
                this.limit = savedLimit;
            }
            this.currentRow = 0;
            this.nextResult = true;
            this.recordEnvironment = null;
            this.updateRecordEnvironment(false);
            this.hitTail = true;
        } else if (this.aggregateFunctions.size() > 0) {
            int savedMaxRows = this.maxRows;
            int savedLimit = this.limit;
            this.maxRows = 0;
            this.limit = -1;
            try {
                while (this.next()) {
                    Iterator<AggregateFunction> iterator = this.aggregateFunctions.iterator();
                    while (iterator.hasNext()) {
                        AggregateFunction o7;
                        AggregateFunction func = o7 = iterator.next();
                        func.processRow(this.recordEnvironment);
                    }
                }
                this.bufferedRecordEnvironments.clear();
                if ((savedLimit < 0 || savedLimit > 0) && sqlOffset == 0) {
                    this.bufferedRecordEnvironments.add(new HashMap());
                }
            }
            finally {
                this.maxRows = savedMaxRows;
                this.limit = savedLimit;
            }
            this.currentRow = 0;
            this.nextResult = true;
            this.recordEnvironment = null;
            this.updateRecordEnvironment(false);
            this.hitTail = true;
        } else if (this.orderByColumns != null) {
            int savedMaxRows = this.maxRows;
            int savedLimit = this.limit;
            this.maxRows = 0;
            this.limit = -1;
            try {
                while (this.next()) {
                }
            }
            finally {
                this.maxRows = savedMaxRows;
                this.limit = savedLimit;
            }
            this.sortRows(sqlOffset);
            this.currentRow = 0;
            this.nextResult = true;
            this.recordEnvironment = null;
            this.updateRecordEnvironment(false);
        } else if (sqlOffset > 0) {
            int savedMaxRows = this.maxRows;
            int savedLimit = this.limit;
            this.maxRows = 0;
            this.limit = -1;
            try {
                while (sqlOffset > 0) {
                    if (!this.next()) {
                        break;
                    }
                    --sqlOffset;
                }
            }
            finally {
                this.maxRows = savedMaxRows;
                this.limit = savedLimit;
                this.currentRow = 0;
                this.nextResult = true;
                if (this.bufferedRecordEnvironments != null) {
                    this.bufferedRecordEnvironments.clear();
                }
            }
        }
    }

    private boolean isScrollable() {
        return this.resultSetType == 1004 || this.resultSetType == 1005;
    }

    private void checkGroupBy(Set<String> allReaderColumns) throws SQLException {
        if (this.groupByColumns != null) {
            Expression expr;
            int i;
            for (Expression expression : this.groupByColumns) {
                List<String> exprUsedColumns = expression.usedColumns(allReaderColumns);
                if (!exprUsedColumns.isEmpty()) continue;
                throw new SQLException(CsvResources.getString("invalidGroupBy") + ": " + expression.toString());
            }
            ArrayList<String> groupingColumns = new ArrayList<String>();
            for (Expression expr3 : this.groupByColumns) {
                groupingColumns.addAll(expr3.usedColumns(allReaderColumns));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (i = 0; i < this.queryEnvironment.size(); ++i) {
                Object[] o2 = this.queryEnvironment.get(i);
                arrayList.add(o2[0].toString());
                if (o2[1] == null) continue;
                expr = (Expression)o2[1];
                for (String o22 : expr.usedColumns(allReaderColumns)) {
                    arrayList.add(o22.toString());
                }
            }
            for (i = 0; i < this.queryEnvironment.size(); ++i) {
                Object[] o = this.queryEnvironment.get(i);
                if (groupingColumns.contains(o[0]) || o[1] == null) continue;
                expr = (Expression)o[1];
                for (String o2 : expr.usedColumns(allReaderColumns)) {
                    String tableAlias;
                    String columnName = o2.toString();
                    if (groupingColumns.contains(columnName) || this.tableName != null && groupingColumns.contains(this.tableName.toUpperCase() + "." + columnName) || (tableAlias = this.reader.getTableAlias()) != null && groupingColumns.contains(tableAlias + "." + columnName)) continue;
                    throw new SQLException(CsvResources.getString("columnNotInGroupBy") + ": " + columnName);
                }
            }
            if (this.havingClause != null) {
                for (String columnName : this.havingClause.usedColumns(allReaderColumns)) {
                    if (arrayList.contains(columnName)) continue;
                    throw new SQLException(CsvResources.getString("invalidHaving") + ": " + columnName);
                }
            }
            if (this.orderByColumns != null) {
                for (Object[] o : this.orderByColumns) {
                    expr = (Expression)o[1];
                    for (String o2 : expr.usedColumns(allReaderColumns)) {
                        if (arrayList.contains(o2.toString())) continue;
                        throw new SQLException(CsvResources.getString("orderByNotInGroupBy") + ": " + o2);
                    }
                }
            }
            boolean hasAggregateFunctions = false;
            for (int i2 = 0; i2 < this.queryEnvironment.size(); ++i2) {
                Object[] o3 = this.queryEnvironment.get(i2);
                Expression expr4 = (Expression)o3[1];
                if (expr4.aggregateFunctions().size() <= 0) continue;
                hasAggregateFunctions = true;
            }
            if (this.havingClause != null && this.havingClause.aggregateFunctions().size() > 0) {
                hasAggregateFunctions = true;
            }
            if (!hasAggregateFunctions) {
                this.distinctValues = new HashSet<ArrayList<Object>>();
                this.distinctColumns = new ArrayList<Expression>(this.groupByColumns);
                this.groupByColumns = null;
            }
        }
    }

    private void sortRows(int sqlOffset) throws SQLException {
        Map[] allRows = new Map[this.bufferedRecordEnvironments.size()];
        for (int i = 0; i < allRows.length; ++i) {
            allRows[i] = this.bufferedRecordEnvironments.get(i);
        }
        this.bufferedRecordEnvironments.clear();
        try {
            Arrays.sort(allRows, new OrderByComparator());
        }
        catch (OrderByException e) {
            throw new SQLException(e.getMessage());
        }
        int rowLimit = allRows.length;
        if (this.maxRows != 0 && this.maxRows < rowLimit) {
            rowLimit = this.maxRows;
        }
        if (this.limit >= 0 && sqlOffset + this.limit < rowLimit) {
            rowLimit = sqlOffset + this.limit;
        }
        for (int i = sqlOffset; i < rowLimit; ++i) {
            this.bufferedRecordEnvironments.add(allRows[i]);
        }
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(CsvResources.getString("closedResultSet"));
        }
    }

    private void checkTimeout() throws SQLTimeoutException {
        if (this.statement.getTimeoutMillis() != Long.MAX_VALUE && System.currentTimeMillis() >= this.statement.getTimeoutMillis()) {
            throw new SQLTimeoutException();
        }
    }

    @Override
    public boolean next() throws SQLException {
        boolean thereWasAnAnswer;
        this.checkOpen();
        this.checkTimeout();
        if (this.statement.isCancelled()) {
            throw new SQLException(CsvResources.getString("statementCancelled"));
        }
        if ((this.groupByColumns != null || this.aggregateFunctions.size() > 0 || this.orderByColumns != null || this.isScrollable()) && this.currentRow < this.bufferedRecordEnvironments.size()) {
            ++this.currentRow;
            this.recordEnvironment = this.bufferedRecordEnvironments.get(this.currentRow - 1);
            this.updateRecordEnvironment(true);
            thereWasAnAnswer = true;
        } else {
            thereWasAnAnswer = this.maxRows != 0 && this.currentRow >= this.maxRows ? false : (this.limit >= 0 && this.currentRow >= this.limit ? false : (this.hitTail ? false : this.reader.next()));
            if (thereWasAnAnswer) {
                this.recordEnvironment = this.reader.getEnvironment();
                this.recordEnvironment.put("@STATEMENT", this.statement);
            } else {
                this.recordEnvironment = null;
            }
            if (this.whereClause != null || this.distinctValues != null) {
                Map<String, Object> objectEnvironment = this.updateRecordEnvironment(thereWasAnAnswer);
                while (thereWasAnAnswer && (this.whereClause != null && !Boolean.TRUE.equals(this.whereClause.isTrue(objectEnvironment)) || this.distinctColumns != null && this.havingClause != null && !Boolean.TRUE.equals(this.havingClause.isTrue(objectEnvironment)) || this.distinctValues != null && !this.addDistinctEnvironment(objectEnvironment))) {
                    thereWasAnAnswer = this.reader.next();
                    if (thereWasAnAnswer) {
                        this.recordEnvironment = this.reader.getEnvironment();
                        this.recordEnvironment.put("@STATEMENT", this.statement);
                    } else {
                        this.recordEnvironment = null;
                    }
                    objectEnvironment = this.updateRecordEnvironment(thereWasAnAnswer);
                }
            }
            if (this.orderByColumns != null || this.isScrollable()) {
                if (thereWasAnAnswer) {
                    Map<String, Object> env = this.reader.getEnvironment();
                    env.put("@STATEMENT", this.statement);
                    this.bufferedRecordEnvironments.add(env);
                    ++this.currentRow;
                } else {
                    this.hitTail = true;
                    this.currentRow = this.bufferedRecordEnvironments.size() + 1;
                }
            } else if (thereWasAnAnswer) {
                ++this.currentRow;
            } else {
                this.hitTail = true;
            }
        }
        this.nextResult = thereWasAnAnswer;
        return thereWasAnAnswer;
    }

    private Map<String, Object> updateRecordEnvironment(boolean thereWasAnAnswer) throws SQLException {
        Object statement;
        Object stringConverter;
        int i;
        MinimumMemoryMap<String, Object> objectEnvironment = new MinimumMemoryMap<String, Object>();
        if (!thereWasAnAnswer) {
            this.recordEnvironment = null;
            return objectEnvironment;
        }
        objectEnvironment.put("@STATEMENT", this.statement);
        objectEnvironment.putAll(this.parentObjectEnvironment);
        for (i = 0; i < this.queryEnvironment.size(); ++i) {
            Object[] o = this.queryEnvironment.get(i);
            String key = (String)o[0];
            Object value = ((Expression)o[1]).eval(this.recordEnvironment);
            objectEnvironment.put(key.toUpperCase(), value);
        }
        for (i = 0; i < this.usedColumns.size(); ++i) {
            String key = this.usedColumns.get(i);
            if (!this.recordEnvironment.containsKey(key = key.toUpperCase())) continue;
            objectEnvironment.put(key, this.recordEnvironment.get(key));
        }
        String key = "@GROUPROWS";
        Object groupRows = this.recordEnvironment.get(key);
        if (groupRows != null) {
            objectEnvironment.put(key, groupRows);
        }
        if ((stringConverter = this.recordEnvironment.get(key = "@STRINGCONVERTER")) != null) {
            objectEnvironment.put(key, stringConverter);
        }
        if ((statement = this.recordEnvironment.get(key = "@STATEMENT")) != null) {
            objectEnvironment.put(key, statement);
        }
        return objectEnvironment;
    }

    private boolean addDistinctEnvironment(Map<String, Object> objectEnvironment) throws SQLException {
        ArrayList<Object> environment;
        if (this.distinctColumns != null) {
            environment = new ArrayList<Object>(this.distinctColumns.size());
            for (int i = 0; i < this.distinctColumns.size(); ++i) {
                Object value = this.distinctColumns.get(i).eval(objectEnvironment);
                environment.add(value);
            }
        } else {
            environment = new ArrayList(this.queryEnvironment.size());
            for (int i = 0; i < this.queryEnvironment.size(); ++i) {
                Object[] o = this.queryEnvironment.get(i);
                Object value = ((Expression)o[1]).eval(objectEnvironment);
                environment.add(value);
            }
        }
        boolean isDistinct = this.distinctValues.add(environment);
        return isDistinct;
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
        this.reader.close();
        this.distinctValues = null;
        this.parentObjectEnvironment = null;
        this.bufferedRecordEnvironments = null;
        this.recordEnvironment = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.lastIndexRead >= 0) {
            return this.getString(this.lastIndexRead) == null;
        }
        throw new SQLException(CsvResources.getString("noGetMethod"));
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Boolean b;
        String s = this.getString(columnIndex);
        if (s != null && (b = this.converter.parseBoolean(s)) != null) {
            return b;
        }
        return false;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Byte b;
        String s = this.getString(columnIndex);
        if (s != null && (b = this.converter.parseByte(s)) != null) {
            return b;
        }
        return 0;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Short n;
        String s = this.getString(columnIndex);
        if (s != null && (n = this.converter.parseShort(s)) != null) {
            return n;
        }
        return 0;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Integer i;
        String s = this.getString(columnIndex);
        if (s != null && (i = this.converter.parseInt(s)) != null) {
            return i;
        }
        return 0;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Long l;
        String s = this.getString(columnIndex);
        if (s != null && (l = this.converter.parseLong(s)) != null) {
            return l;
        }
        return 0L;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Float f;
        String s = this.getString(columnIndex);
        if (s != null && (f = this.converter.parseFloat(s)) != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Double d;
        String s = this.getString(columnIndex);
        if (s != null && (d = this.converter.parseDouble(s)) != null) {
            return d;
        }
        return 0.0;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            return this.converter.parseBytes(s);
        }
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.getObject(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.getObject(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        if (o instanceof Date) {
            o = new Timestamp(((Date)o).getTime());
        }
        return (Timestamp)o;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            return this.converter.parseAsciiStream(s);
        }
        return null;
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getAsciiStream(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException(CsvResources.getString("methodNotSupported") + ": ResultSet.getCursorName()");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.resultSetMetaData == null) {
            int i;
            String[] readerTypeNames = this.reader.getColumnTypes();
            String[] readerColumnNames = this.reader.getColumnNames();
            int[] readerColumnSizes = this.reader.getColumnSizes();
            String tableAlias = this.reader.getTableAlias();
            int columnCount = this.queryEnvironment.size();
            String[] columnNames = new String[columnCount];
            String[] columnLabels = new String[columnCount];
            int[] columnSizes = new int[columnCount];
            String[] typeNames = new String[columnCount];
            HashSet<String> allReaderColumns = new HashSet<String>();
            HashMap<String, Object> env = new HashMap<String, Object>();
            for (i = 0; i < readerTypeNames.length; ++i) {
                Object literal = StringConverter.getLiteralForTypeName(readerTypeNames[i]);
                String columnName = readerColumnNames[i].toUpperCase();
                env.put(columnName, literal);
                allReaderColumns.add(columnName);
                if (this.tableName != null) {
                    env.put(this.tableName.toUpperCase() + "." + columnName, literal);
                    allReaderColumns.add(this.tableName.toUpperCase() + "." + columnName);
                }
                if (tableAlias == null) continue;
                env.put(tableAlias + "." + columnName, literal);
                allReaderColumns.add(tableAlias + "." + columnName);
            }
            if (this.converter != null) {
                env.put("@STRINGCONVERTER", this.converter);
            }
            env.put("@STATEMENT", this.statement);
            for (i = 0; i < columnCount; ++i) {
                Object[] o = this.queryEnvironment.get(i);
                columnNames[i] = (String)o[0];
                for (int j = 0; j < readerColumnNames.length; ++j) {
                    if (!columnNames[i].equalsIgnoreCase(readerColumnNames[j])) continue;
                    columnNames[i] = readerColumnNames[j];
                    break;
                }
                columnLabels[i] = columnNames[i];
                Object result = null;
                try {
                    Expression expr = (Expression)o[1];
                    int columnSize = 20;
                    if (expr instanceof ColumnName) {
                        String usedColumn = expr.usedColumns(allReaderColumns).get(0);
                        for (int k = 0; k < readerColumnNames.length; ++k) {
                            if (!usedColumn.equalsIgnoreCase(readerColumnNames[k])) continue;
                            columnSize = readerColumnSizes[k];
                            break;
                        }
                    }
                    columnSizes[i] = columnSize;
                    result = expr.eval(env);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                typeNames[i] = result != null ? StringConverter.getTypeNameForLiteral(result) : "expression";
            }
            this.resultSetMetaData = new CsvResultSetMetaData(this.tableName, columnNames, columnLabels, typeNames, columnSizes);
        }
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.preAccessor(columnIndex);
        Object[] o = this.queryEnvironment.get(columnIndex - 1);
        if (this.recordEnvironment != null) {
            return ((Expression)o[1]).eval(this.recordEnvironment);
        }
        return null;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        return str == null ? null : new StringReader(str);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        String str = this.getString(columnName);
        return str == null ? null : new StringReader(str);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        BigDecimal retval = null;
        String str = this.getString(columnIndex);
        if (str != null) {
            try {
                retval = new BigDecimal(str);
            }
            catch (NumberFormatException e) {
                throw new SQLException(CsvResources.getString("cannotConvertToBigDecimal") + ": " + str);
            }
        }
        return retval;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            return this.currentRow == 0;
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.isBeforeFirst()");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            return this.currentRow == this.bufferedRecordEnvironments.size() + 1;
        }
        return !this.nextResult && this.currentRow > 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            return this.currentRow == 1;
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.isFirst()");
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            if (!this.hitTail && this.currentRow != 0) {
                this.next();
                this.previous();
            }
            return this.currentRow == this.bufferedRecordEnvironments.size();
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.isLast()");
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkOpen();
        if (!this.isScrollable()) {
            throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.beforeFirst()");
        }
        this.first();
        this.previous();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            while (this.next()) {
            }
        } else {
            throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.afterLast()");
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            this.currentRow = 0;
            boolean thereWasAnAnswer = this.next();
            this.updateRecordEnvironment(thereWasAnAnswer);
            return thereWasAnAnswer;
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.first()");
    }

    @Override
    public boolean last() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            this.afterLast();
            this.previous();
            return this.bufferedRecordEnvironments.size() != 0;
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.last()");
    }

    @Override
    public int getRow() throws SQLException {
        this.checkOpen();
        if (!this.isScrollable() && !this.nextResult) {
            return 0;
        }
        return this.currentRow;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            boolean found;
            if (row < 0) {
                this.last();
                row = this.currentRow + row + 1;
            } else {
                while (this.bufferedRecordEnvironments.size() < row && this.next()) {
                }
            }
            if (row <= 0) {
                found = false;
                this.currentRow = 0;
            } else if (row > this.bufferedRecordEnvironments.size()) {
                found = false;
                this.currentRow = this.bufferedRecordEnvironments.size() + 1;
            } else {
                found = true;
                this.currentRow = row;
                this.recordEnvironment = this.bufferedRecordEnvironments.get(this.currentRow - 1);
            }
            this.updateRecordEnvironment(found);
            return found;
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.absolute()");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            if (this.currentRow + rows >= 0) {
                return this.absolute(this.currentRow + rows);
            }
            this.currentRow = 0;
            this.updateRecordEnvironment(false);
            return false;
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.relative()");
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkOpen();
        if (this.isScrollable()) {
            if (this.currentRow > 1) {
                --this.currentRow;
                this.recordEnvironment = this.bufferedRecordEnvironments.get(this.currentRow - 1);
                this.updateRecordEnvironment(true);
                return true;
            }
            this.currentRow = 0;
            this.recordEnvironment = null;
            this.updateRecordEnvironment(false);
            return false;
        }
        throw new SQLException(CsvResources.getString("wrongResultSetType") + ": ResultSet.previous()");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException(CsvResources.getString("unsupportedDirection") + ": " + direction);
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.rowUpdated()");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.rowInserted()");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.rowDeleted()");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateNull(int)");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBoolean(int, boolean)");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateByte(int, byte)");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateShort(int, short)");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateInt(int, int)");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateLong(int, long)");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateFloat(int, float)");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateDouble(int, double)");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBigDecimal(int, BigDecimal)");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateString(int, String)");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBytes(int, byte[])");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateDate(int, Date)");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateTime(int, Time)");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateTimestamp(int, Timestamp)");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateAsciiStream(int, InputStream, int)");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBinaryStreamint, InputStream, int)");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateCharacterStream(int, Reader, int)");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.udpateObject(int, Object)");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateObject(int, Object, int)");
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateNull(String)");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBoolean(String, boolean)");
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateByte(String, byte)");
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateShort(String, short)");
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateInt(String, int)");
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateLong(String, long)");
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateFloat(String, float)");
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateDouble(String, double)");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBigDecimal(String, BigDecimal)");
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateString(String, String)");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBytes(String, byte[])");
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateDate(String, Date)");
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateTime(String, Time)");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateTimestamp(String, Timestamp)");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateAsciiStream(String, InputStream, int)");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBinaryStream(String, InputStream, int)");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateCharacterStream(String, Reader, int)");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateObject(String, Object, int)");
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateObject(String, Object)");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.insertRow()");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateRow()");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.deleteRow()");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.refreshRow()");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.cancelRowUpdates()");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.moveToInsertRow()");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.moveToeCurrentRow()");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getObject(int, Map)");
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getRef(int)");
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getBlob(int)");
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getClob(int)");
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getArray(int)");
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getObject(String, Map)");
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getRef(String)");
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getBlob(String)");
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getClob(String)");
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getArray(String)");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getDate(int, Calendar)");
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getDate(String, Calendar)");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getTime(int, Calendar)");
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getTime(String, Calendar)");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getTimestamp(int, Calendar)");
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getTimestamp(String, Calendar)");
    }

    private void preAccessor(int columnIndex) throws SQLException {
        this.lastIndexRead = columnIndex;
        this.checkOpen();
        if (columnIndex < 1 || columnIndex > this.queryEnvironment.size()) {
            throw new SQLException(CsvResources.getString("invalidColumnIndex") + ": " + columnIndex);
        }
        if (this.currentRow == 0) {
            throw new SQLException(CsvResources.getString("noCurrentRow"));
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getURL(int)");
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getURL(String)");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateRef(int,java.sql.Ref)");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateRef(String,java.sql.Ref)");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBlob(int,java.sql.Blob)");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateBlob(String,java.sql.Blob)");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateClob(int,java.sql.Clob)");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateClob(String,java.sql.Clob)");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateArray(int,java.sql.Array)");
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.updateArray(String,java.sql.Array)");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkOpen();
        if (columnLabel.equals("")) {
            throw new SQLException(CsvResources.getString("invalidColumnName") + ": " + columnLabel);
        }
        for (int i = 0; i < this.queryEnvironment.size(); ++i) {
            Object[] queryEnvEntry = this.queryEnvironment.get(i);
            if (!((String)queryEnvEntry[0]).equalsIgnoreCase(columnLabel)) continue;
            return i + 1;
        }
        throw new SQLException(CsvResources.getString("invalidColumnName") + ": " + columnLabel);
    }

    @Override
    public NClob getNClob(int arg0) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String arg0) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(int arg0) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String arg0) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int arg0) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String arg0) throws SQLException {
        return null;
    }

    @Override
    public void updateNClob(int arg0, NClob arg1) throws SQLException {
    }

    @Override
    public void updateNClob(String arg0, NClob arg1) throws SQLException {
    }

    @Override
    public void updateRowId(int arg0, RowId arg1) throws SQLException {
    }

    @Override
    public void updateRowId(String arg0, RowId arg1) throws SQLException {
    }

    @Override
    public void updateSQLXML(int arg0, SQLXML arg1) throws SQLException {
    }

    @Override
    public void updateSQLXML(String arg0, SQLXML arg1) throws SQLException {
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getObject(String, Class<T>)");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": ResultSet.getObject(int, Class<T>)");
    }

    public class OrderByComparator
    implements Comparator<Map<String, Object>> {
        @Override
        public int compare(Map<String, Object> recordEnvironment1, Map<String, Object> recordEnvironment2) {
            int retval = 0;
            try {
                for (int i = 0; i < CsvResultSet.this.orderByColumns.size() && retval == 0; ++i) {
                    Object[] o = (Object[])CsvResultSet.this.orderByColumns.get(i);
                    Integer direction = (Integer)o[0];
                    Expression expr = (Expression)o[1];
                    CsvResultSet.this.recordEnvironment = recordEnvironment1;
                    Map objectEnvironment1 = CsvResultSet.this.updateRecordEnvironment(true);
                    if (CsvResultSet.this.converter != null) {
                        objectEnvironment1.put("@STRINGCONVERTER", CsvResultSet.this.converter);
                    }
                    Comparable result1 = (Comparable)expr.eval(objectEnvironment1);
                    CsvResultSet.this.recordEnvironment = recordEnvironment2;
                    Map objectEnvironment2 = CsvResultSet.this.updateRecordEnvironment(true);
                    if (CsvResultSet.this.converter != null) {
                        objectEnvironment2.put("@STRINGCONVERTER", CsvResultSet.this.converter);
                    }
                    Comparable result2 = (Comparable)expr.eval(objectEnvironment2);
                    retval = result1 == null ? (result2 == null ? 0 : -1) : (result2 == null ? 1 : result1.compareTo(result2));
                    if (direction >= 0) continue;
                    retval = -retval;
                }
            }
            catch (SQLException e) {
                throw new OrderByException(e.getMessage());
            }
            return retval;
        }
    }

    public class OrderByException
    extends RuntimeException {
        public OrderByException(String message) {
            super(message);
        }
    }
}

