/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.sasl.AuthenticationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.ServiceUtils;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;

public class LdapAuthenticationProviderImpl
implements PasswdAuthenticationProvider {
    private static final Log LOG = LogFactory.getLog(LdapAuthenticationProviderImpl.class);
    private String ldapURL;
    private String baseDN;
    private String ldapDomain;
    private static List<String> groupBases;
    private static List<String> userBases;
    private static List<String> userFilter;
    private static List<String> groupFilter;
    private String customQuery;
    private static String guid_attr;
    private static String groupMembership_attr;
    private static String groupClass_attr;

    LdapAuthenticationProviderImpl() {
        HiveConf conf = new HiveConf();
        this.init(conf);
    }

    protected void init(HiveConf conf) {
        int i;
        this.ldapURL = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_URL);
        this.baseDN = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BASEDN);
        this.ldapDomain = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_DOMAIN);
        this.customQuery = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_CUSTOMLDAPQUERY);
        guid_attr = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GUIDKEY);
        groupBases = new ArrayList<String>();
        userBases = new ArrayList<String>();
        userFilter = new ArrayList<String>();
        groupFilter = new ArrayList<String>();
        String groupDNPatterns = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPDNPATTERN);
        String groupFilterVal = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPFILTER);
        String userDNPatterns = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERDNPATTERN);
        String userFilterVal = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER);
        groupMembership_attr = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPMEMBERSHIP_KEY);
        groupClass_attr = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPCLASS_KEY);
        if (groupDNPatterns != null && groupDNPatterns.trim().length() > 0) {
            String[] groupTokens = groupDNPatterns.split(":");
            for (i = 0; i < groupTokens.length; ++i) {
                if (groupTokens[i].contains(",") && groupTokens[i].contains("=")) {
                    groupBases.add(groupTokens[i]);
                    continue;
                }
                LOG.warn("Unexpected format for " + (Object)((Object)HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPDNPATTERN) + "..ignoring " + groupTokens[i]);
            }
        } else if (this.baseDN != null) {
            groupBases.add(guid_attr + "=%s," + this.baseDN);
        }
        if (groupFilterVal != null && groupFilterVal.trim().length() > 0) {
            String[] groups = groupFilterVal.split(",");
            for (i = 0; i < groups.length; ++i) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Filtered group: " + groups[i]);
                }
                groupFilter.add(groups[i]);
            }
        }
        if (userDNPatterns != null && userDNPatterns.trim().length() > 0) {
            String[] userTokens = userDNPatterns.split(":");
            for (i = 0; i < userTokens.length; ++i) {
                if (userTokens[i].contains(",") && userTokens[i].contains("=")) {
                    userBases.add(userTokens[i]);
                    continue;
                }
                LOG.warn("Unexpected format for " + (Object)((Object)HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERDNPATTERN) + "..ignoring " + userTokens[i]);
            }
        } else if (this.baseDN != null) {
            userBases.add(guid_attr + "=%s," + this.baseDN);
        }
        if (userFilterVal != null && userFilterVal.trim().length() > 0) {
            String[] users = userFilterVal.split(",");
            for (i = 0; i < users.length; ++i) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Filtered user: " + users[i]);
                }
                userFilter.add(users[i]);
            }
        }
    }

    @Override
    public void Authenticate(String user, String password) throws AuthenticationException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapURL);
        if (!this.hasDomain(user) && this.ldapDomain != null) {
            user = user + "@" + this.ldapDomain;
        }
        if (password == null || password.isEmpty() || password.getBytes()[0] == 0) {
            throw new AuthenticationException("Error validating LDAP user: a null or blank password has been provided");
        }
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.credentials", password);
        String bindDN = null;
        InitialDirContext ctx = null;
        String userDN = null;
        String userName = null;
        NamingException ex = null;
        if (!LdapAuthenticationProviderImpl.isDN(user) && !this.hasDomain(user) && userBases.size() > 0) {
            ListIterator<String> listIter = userBases.listIterator();
            while (listIter.hasNext()) {
                try {
                    bindDN = listIter.next().replaceAll("%s", user);
                    env.put("java.naming.security.principal", bindDN);
                    LOG.debug("Connecting using DN " + bindDN + " at url " + this.ldapURL);
                    ctx = new InitialDirContext(env);
                    break;
                }
                catch (NamingException e) {
                    ex = e;
                }
            }
        } else {
            env.put("java.naming.security.principal", user);
            LOG.debug("Connecting using principal " + user + " at url " + this.ldapURL);
            try {
                ctx = new InitialDirContext(env);
            }
            catch (NamingException e) {
                ex = e;
            }
        }
        if (ctx == null) {
            LOG.debug("Could not connect to the LDAP Server:Authentication failed for " + user);
            throw new AuthenticationException("LDAP Authentication failed for user", ex);
        }
        LOG.debug("Connected using principal=" + user + " at url=" + this.ldapURL);
        try {
            userName = LdapAuthenticationProviderImpl.isDN(user) || this.hasDomain(user) ? LdapAuthenticationProviderImpl.extractName(user) : user;
            if (this.customQuery != null) {
                List<String> resultList = LdapAuthenticationProviderImpl.executeLDAPQuery(ctx, this.customQuery, this.baseDN);
                if (resultList != null) {
                    for (String matchedDN : resultList) {
                        LOG.info("<queried user=" + matchedDN.split(",", 2)[0].split("=", 2)[1] + ",user=" + user + ">");
                        if (!matchedDN.split(",", 2)[0].split("=", 2)[1].equalsIgnoreCase(user) && !matchedDN.equalsIgnoreCase(user)) continue;
                        LOG.info("Authentication succeeded based on result set from LDAP query");
                        return;
                    }
                }
                LOG.info("Authentication failed based on result set from custom LDAP query");
                throw new AuthenticationException("Authentication failed: LDAP query from property returned no data");
            }
            if (userBases.size() > 0) {
                if (LdapAuthenticationProviderImpl.isDN(user)) {
                    userDN = LdapAuthenticationProviderImpl.findUserDNByDN(ctx, user);
                } else {
                    if (userDN == null) {
                        userDN = LdapAuthenticationProviderImpl.findUserDNByPattern(ctx, userName);
                    }
                    if (userDN == null) {
                        userDN = LdapAuthenticationProviderImpl.findUserDNByName(ctx, userName);
                    }
                }
                if (userDN == null) {
                    throw new AuthenticationException("Authentication failed: User search failed");
                }
                if (userFilter.size() > 0) {
                    LOG.info("Authenticating user " + user + " using user filter");
                    if (userDN != null) {
                        LOG.info("User filter partially satisfied");
                    }
                    boolean success = false;
                    for (String filteredUser : userFilter) {
                        if (!filteredUser.equalsIgnoreCase(userName)) continue;
                        LOG.debug("User filter entirely satisfied");
                        success = true;
                        break;
                    }
                    if (!success) {
                        LOG.info("Authentication failed based on user membership");
                        throw new AuthenticationException("Authentication failed: User not a member of specified list");
                    }
                }
                if (groupFilter.size() > 0) {
                    LOG.debug("Authenticating user " + user + " using group membership");
                    List<String> userGroups = LdapAuthenticationProviderImpl.getGroupsForUser(ctx, userDN);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("User member of :");
                        LdapAuthenticationProviderImpl.prettyPrint(userGroups);
                    }
                    if (userGroups != null) {
                        for (String elem : userGroups) {
                            String shortName = elem.split(",")[0].split("=")[1];
                            if (!groupFilter.contains(shortName)) continue;
                            LOG.info("Authentication succeeded based on group membership");
                            return;
                        }
                    }
                    LOG.debug("Authentication failed: User is not a member of configured groups");
                    throw new AuthenticationException("Authentication failed: User not a member of listed groups");
                }
                LOG.info("Authentication succeeded using ldap user search");
                return;
            }
            LOG.info("Simple password authentication succeeded");
        }
        catch (NamingException e) {
            throw new AuthenticationException("LDAP Authentication failed for user", e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Exception when closing LDAP context:" + e.getMessage());
            }
        }
    }

    private boolean hasDomain(String userName) {
        return ServiceUtils.indexOfDomainMatch(userName) > 0;
    }

    private static void prettyPrint(List<String> list) {
        for (String elem : list) {
            LOG.debug("    " + elem);
        }
    }

    private static void prettyPrint(Attributes attrs) {
        NamingEnumeration<? extends Attribute> set = attrs.getAll();
        try {
            NamingEnumeration<?> list = null;
            while (set.hasMore()) {
                Attribute attr = set.next();
                list = attr.getAll();
                String attrVals = "";
                while (list.hasMore()) {
                    attrVals = attrVals + list.next() + "+";
                }
                LOG.debug(attr.getID() + ":::" + attrVals);
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred when reading ldap data:" + e.getMessage());
        }
    }

    public static String findGroupDNByName(DirContext ctx, String baseDN, String groupName) throws NamingException {
        String searchFilter = "(&(objectClass=" + groupClass_attr + ")(" + guid_attr + "=" + groupName + "))";
        List<String> results = null;
        results = LdapAuthenticationProviderImpl.findDNByName(ctx, baseDN, searchFilter, 2);
        if (results == null) {
            return null;
        }
        if (results.size() > 1) {
            LOG.info("Matched multiple groups for the group: " + groupName + ",returning null");
            return null;
        }
        return results.get(0);
    }

    public static String findGroupDNByPattern(DirContext ctx, String groupName) throws NamingException {
        return LdapAuthenticationProviderImpl.findDNByPattern(ctx, groupName, groupBases);
    }

    public static String findDNByPattern(DirContext ctx, String name, List<String> nodes) throws NamingException {
        SearchResult searchResult = null;
        String[] returnAttributes = new String[]{};
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(returnAttributes);
        for (String node : nodes) {
            String searchFilter = "(" + node.substring(0, node.indexOf(",")).replaceAll("%s", name) + ")";
            String searchBase = node.split(",", 2)[1];
            NamingEnumeration<SearchResult> results = ctx.search(searchBase, searchFilter, searchControls);
            if (!results.hasMoreElements()) continue;
            searchResult = (SearchResult)results.nextElement();
            if (results.hasMoreElements()) {
                LOG.warn("Matched multiple entities for the name: " + name);
                return null;
            }
            return searchResult.getNameInNamespace();
        }
        return null;
    }

    public static String findUserDNByName(DirContext ctx, String userName) throws NamingException {
        if (userBases.size() == 0) {
            return null;
        }
        String baseFilter = "(&(|(objectClass=person)(objectClass=user)(objectClass=inetOrgPerson))";
        String[] suffix = new String[]{"(|(uid=" + userName + ")(sAMAccountName=" + userName + ")))", "(|(cn=*" + userName + "*)))"};
        String searchFilter = null;
        List<String> results = null;
        ListIterator<String> listIter = userBases.listIterator();
        for (int i = 0; i < suffix.length; ++i) {
            searchFilter = baseFilter + suffix[i];
            while (listIter.hasNext()) {
                results = LdapAuthenticationProviderImpl.findDNByName(ctx, listIter.next().split(",", 2)[1], searchFilter, 2);
                if (results == null) continue;
                if (results != null && results.size() > 1) {
                    LOG.info("Matched multiple users for the user: " + userName + ",returning null");
                    return null;
                }
                return results.get(0);
            }
        }
        return null;
    }

    public static String findUserDNByDN(DirContext ctx, String userDN) throws NamingException {
        if (!LdapAuthenticationProviderImpl.isDN(userDN)) {
            return null;
        }
        String baseDN = LdapAuthenticationProviderImpl.extractBaseDN(userDN);
        List<String> results = null;
        String searchFilter = "(&(|(objectClass=person)(objectClass=user)(objectClass=inetOrgPerson))(" + userDN.substring(0, userDN.indexOf(",")) + "))";
        results = LdapAuthenticationProviderImpl.findDNByName(ctx, baseDN, searchFilter, 2);
        if (results == null) {
            return null;
        }
        if (results.size() > 1) {
            LOG.info("Matched multiple users for the user: " + userDN + ",returning null");
            return null;
        }
        return results.get(0);
    }

    public static List<String> findDNByName(DirContext ctx, String baseDN, String searchString, int limit) throws NamingException {
        SearchResult searchResult = null;
        ArrayList<String> retValues = null;
        String matchedDN = null;
        SearchControls searchControls = new SearchControls();
        String[] returnAttributes = new String[]{};
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(returnAttributes);
        if (limit > 0) {
            searchControls.setCountLimit(limit);
        }
        NamingEnumeration<SearchResult> results = ctx.search(baseDN, searchString, searchControls);
        while (results.hasMoreElements()) {
            searchResult = (SearchResult)results.nextElement();
            matchedDN = searchResult.getNameInNamespace();
            if (retValues == null) {
                retValues = new ArrayList<String>();
            }
            retValues.add(matchedDN);
        }
        return retValues;
    }

    public static String findUserDNByPattern(DirContext ctx, String userName) throws NamingException {
        return LdapAuthenticationProviderImpl.findDNByPattern(ctx, userName, userBases);
    }

    public static List<String> getGroupsForUser(DirContext ctx, String userDN) throws NamingException {
        ArrayList<String> groupList = new ArrayList<String>();
        String user = LdapAuthenticationProviderImpl.extractName(userDN);
        String searchFilter = "(&(objectClass=" + groupClass_attr + ")(|(" + groupMembership_attr + "=" + userDN + ")(" + groupMembership_attr + "=" + user + ")))";
        SearchControls searchControls = new SearchControls();
        NamingEnumeration<SearchResult> results = null;
        SearchResult result = null;
        String groupBase = null;
        LOG.debug("getGroupsForUser:searchFilter=" + searchFilter);
        String[] attrIDs = new String[]{};
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(attrIDs);
        ListIterator<String> listIter = groupBases.listIterator();
        while (listIter.hasNext()) {
            try {
                groupBase = listIter.next().split(",", 2)[1];
                LOG.debug("Searching for groups under " + groupBase);
                results = ctx.search(groupBase, searchFilter, searchControls);
                while (results.hasMoreElements()) {
                    result = (SearchResult)results.nextElement();
                    LOG.debug("Found Group:" + result.getNameInNamespace());
                    groupList.add(result.getNameInNamespace());
                }
            }
            catch (NamingException e) {
                LOG.warn("Exception searching for user groups", e);
            }
        }
        return groupList;
    }

    public static List<String> executeLDAPQuery(DirContext ctx, String query, String rootDN) throws NamingException {
        if (rootDN == null) {
            return null;
        }
        SearchControls searchControls = new SearchControls();
        ArrayList<String> list = new ArrayList<String>();
        String[] returnAttributes = new String[]{};
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(returnAttributes);
        LOG.info("Using a user specified LDAP query for adjudication:" + query + ",baseDN=" + rootDN);
        NamingEnumeration<SearchResult> results = ctx.search(rootDN, query, searchControls);
        SearchResult searchResult = null;
        while (results.hasMoreElements()) {
            searchResult = (SearchResult)results.nextElement();
            list.add(searchResult.getNameInNamespace());
            LOG.debug("LDAPAtn:executeLDAPQuery()::Return set size " + (String)list.get(list.size() - 1));
        }
        return list;
    }

    public static boolean isDN(String name) {
        return name.indexOf("=") > -1;
    }

    public static String extractName(String dn) {
        int domainIdx = ServiceUtils.indexOfDomainMatch(dn);
        if (domainIdx > 0) {
            return dn.substring(0, domainIdx);
        }
        if (dn.indexOf("=") > -1) {
            return dn.substring(dn.indexOf("=") + 1, dn.indexOf(","));
        }
        return dn;
    }

    public static String extractBaseDN(String dn) {
        if (dn.indexOf(",") > -1) {
            return dn.substring(dn.indexOf(",") + 1);
        }
        return null;
    }
}

