/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.merge;

import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.merge.MergeStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="merge", description="Merge", priority=1)
public class MergeChange
extends AbstractChange {
    private String sourceTableName;
    private String sourceSchemaName;
    private String targetSchemaName;
    private String targetTableName;
    private String onCondition;
    private String updateCondition;
    private String deleteCondition;
    private String insertCondition;
    private String insertColumnsNameList;
    private String insertColumnsValueList;
    private String updateList;

    public String getSourceTableName() {
        return this.sourceTableName;
    }

    public void setSourceTableName(String sourceTableName) {
        this.sourceTableName = sourceTableName;
    }

    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    public void setSourceSchemaName(String sourceSchemaName) {
        this.sourceSchemaName = sourceSchemaName;
    }

    public String getTargetSchemaName() {
        return this.targetSchemaName;
    }

    public void setTargetSchemaName(String targetSchemaName) {
        this.targetSchemaName = targetSchemaName;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public void setTargetTableName(String targetTableName) {
        this.targetTableName = targetTableName;
    }

    public String getOnCondition() {
        return this.onCondition;
    }

    public void setOnCondition(String onCondition) {
        this.onCondition = onCondition;
    }

    public String getUpdateCondition() {
        return this.updateCondition;
    }

    public void setUpdateCondition(String updateCondition) {
        this.updateCondition = updateCondition;
    }

    public String getDeleteCondition() {
        return this.deleteCondition;
    }

    public void setDeleteCondition(String deleteCondition) {
        this.deleteCondition = deleteCondition;
    }

    public String getInsertCondition() {
        return this.insertCondition;
    }

    public void setInsertCondition(String insertCondition) {
        this.insertCondition = insertCondition;
    }

    public String getInsertColumnsNameList() {
        return this.insertColumnsNameList;
    }

    public void setInsertColumnsNameList(String insertColumnsNameList) {
        this.insertColumnsNameList = insertColumnsNameList;
    }

    public String getInsertColumnsValueList() {
        return this.insertColumnsValueList;
    }

    public void setInsertColumnsValueList(String insertColumnsValueList) {
        this.insertColumnsValueList = insertColumnsValueList;
    }

    public String getUpdateList() {
        return this.updateList;
    }

    public void setUpdateList(String updateList) {
        this.updateList = updateList;
    }

    public SqlStatement[] generateStatements(Database database) {
        String sourceSchemaName = this.getSourceSchemaName() == null ? database.getDefaultSchemaName() : this.getSourceSchemaName();
        String targetSchemaName = this.getTargetSchemaName() == null ? database.getDefaultSchemaName() : this.getTargetSchemaName();
        MergeStatement statement = new MergeStatement(this.getSourceTableName(), sourceSchemaName, this.getTargetTableName(), targetSchemaName);
        statement.setOnCondition(this.getOnCondition());
        statement.setDeleteCondition(this.getDeleteCondition());
        statement.setInsertCondition(this.getInsertCondition());
        statement.setUpdateCondition(this.getUpdateCondition());
        statement.setInsertColumnsNameList(this.getInsertColumnsNameList());
        statement.setInsertColumnsValueList(this.getInsertColumnsValueList());
        statement.setUpdateList(this.getUpdateList());
        return new SqlStatement[]{statement};
    }

    public String getConfirmationMessage() {
        return "Tables " + this.getSourceTableName() + " & " + this.getTargetTableName() + " merged";
    }
}

