/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.adddeferredprimarykey;

import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.core.DropPrimaryKeyChange;
import liquibase.database.Database;
import liquibase.ext.ora.adddeferredprimarykey.AddDeferredPrimaryKeyStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="addDeferredPrimaryKey", description="Add deferred primary key", priority=1)
public class AddDeferredPrimaryKeyChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String constraintName;
    private String columnNames;
    private Boolean deferrable;
    private Boolean initiallyDeferred;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public String getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String columnNames) {
        this.columnNames = columnNames;
    }

    public Boolean getDeferrable() {
        return this.deferrable;
    }

    public void setDeferrable(Boolean deferrable) {
        this.deferrable = deferrable;
    }

    public Boolean getInitiallyDeferred() {
        return this.initiallyDeferred;
    }

    public void setInitiallyDeferred(Boolean initiallyDerred) {
        this.initiallyDeferred = initiallyDerred;
    }

    public SqlStatement[] generateStatements(Database database) {
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        boolean deferrable = false;
        if (this.getDeferrable() != null) {
            deferrable = this.getDeferrable();
        }
        boolean initiallyDeferred = false;
        if (this.getInitiallyDeferred() != null) {
            initiallyDeferred = this.getInitiallyDeferred();
        }
        AddDeferredPrimaryKeyStatement statement = new AddDeferredPrimaryKeyStatement(schemaName, this.getTableName(), this.getColumnNames(), this.getConstraintName());
        statement.setDeferrable(deferrable);
        statement.setInitiallyDeferred(initiallyDeferred);
        return new SqlStatement[]{statement};
    }

    protected Change[] createInverses() {
        DropPrimaryKeyChange inverse = new DropPrimaryKeyChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setConstraintName(this.getConstraintName());
        return new Change[]{inverse};
    }

    public String getConfirmationMessage() {
        return "Deferred primary key added to " + this.getTableName() + " (" + this.getColumnNames() + ")";
    }
}

