/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.notifications;

import java.util.Date;
import org.eclipse.mylyn.commons.notifications.ui.AbstractUiNotification;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPMessageType;

public class DatabaseNotification
extends AbstractUiNotification {
    private final String label;
    private final String description;
    private final DBPMessageType messageType;
    private final Runnable feedback;
    private final Date date;

    public DatabaseNotification(@Nullable DBPDataSource dataSource, @NotNull String id, @NotNull String description, @Nullable DBPMessageType messageType, @Nullable Runnable feedback) {
        super("org.jkiss.dbeaver.notifications.event." + id);
        this.label = dataSource.getContainer().getName();
        this.description = description;
        this.messageType = messageType;
        this.feedback = feedback;
        this.date = new Date();
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getDate() {
        return this.date;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public Image getNotificationImage() {
        return null;
    }

    public Image getNotificationKindImage() {
        int iconType;
        if (this.messageType == null) {
            return null;
        }
        switch (this.messageType) {
            case ERROR: {
                iconType = 1;
                break;
            }
            case WARNING: {
                iconType = 8;
                break;
            }
            default: {
                iconType = 2;
            }
        }
        return Display.getDefault().getSystemImage(iconType);
    }

    public void open() {
        if (this.feedback != null) {
            this.feedback.run();
        }
    }
}

