/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDContentStorageLocal;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class TemporaryContentStorage
implements DBDContentStorageLocal {
    private final DBPPlatform platform;
    private File file;
    private String charset;

    public TemporaryContentStorage(DBPPlatform platform, File file, String charset) {
        this.platform = platform;
        this.file = file;
        this.charset = CommonUtils.toString((Object)charset, (String)"UTF-8");
    }

    @Override
    public InputStream getContentStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public Reader getContentReader() throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream(this.file), this.charset);
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public DBDContentStorage cloneStorage(DBRProgressMonitor monitor) throws IOException {
        File tempFile = ContentUtils.createTempContentFile(monitor, this.platform, "copy" + this.hashCode());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream is = new FileInputStream(this.file);){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (FileOutputStream os = new FileOutputStream(tempFile);){
                    ContentUtils.copyStreams(is, this.file.length(), os, monitor);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            ContentUtils.deleteTempFile(tempFile);
            throw new IOException(e);
        }
        return new TemporaryContentStorage(this.platform, tempFile, this.charset);
    }

    @Override
    public void release() {
        ContentUtils.deleteTempFile(this.file);
    }

    @Override
    public File getDataFile() {
        return this.file;
    }
}

