/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Collection;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBConstants;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public final class DBValueFormatting {
    public static final DecimalFormat NATIVE_DECIMAL_FORMATTER = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private static final Log log = Log.getLog(DBValueFormatting.class);

    static {
        NATIVE_DECIMAL_FORMATTER.setMaximumFractionDigits(340);
    }

    @NotNull
    public static DBPImage getTypeImage(@NotNull DBSTypedObject typedObject) {
        DBPImage image;
        DBSDataType dataType;
        if (typedObject instanceof DBSTypedObjectEx && (dataType = ((DBSTypedObjectEx)((Object)typedObject)).getDataType()) instanceof DBPImageProvider && (image = ((DBPImageProvider)((Object)dataType)).getObjectImage()) != null) {
            return image;
        }
        return DBValueFormatting.getDefaultTypeImage(typedObject);
    }

    @NotNull
    public static DBPImage getDefaultTypeImage(DBSTypedObject typedObject) {
        String typeName = typedObject.getTypeName();
        switch (typedObject.getDataKind()) {
            case BOOLEAN: {
                return DBIcon.TYPE_BOOLEAN;
            }
            case STRING: {
                return DBIcon.TYPE_STRING;
            }
            case NUMERIC: {
                return DBIcon.TYPE_NUMBER;
            }
            case DATETIME: {
                return DBIcon.TYPE_DATETIME;
            }
            case BINARY: {
                return DBIcon.TYPE_BINARY;
            }
            case CONTENT: {
                if (DBValueFormatting.typeNameContains(typeName, "XML", DBConstants.TYPE_NAME_XML2)) {
                    return DBIcon.TYPE_XML;
                }
                if (DBValueFormatting.typeNameContains(typeName, "CHAR", DBConstants.TYPE_NAME_CHAR2)) {
                    return DBIcon.TYPE_TEXT;
                }
                return DBIcon.TYPE_LOB;
            }
            case ARRAY: {
                return DBIcon.TYPE_ARRAY;
            }
            case STRUCT: {
                return DBIcon.TYPE_STRUCT;
            }
            case DOCUMENT: {
                return DBIcon.TYPE_DOCUMENT;
            }
            case REFERENCE: {
                return DBIcon.TYPE_REFERENCE;
            }
            case ROWID: {
                return DBIcon.TYPE_ROWID;
            }
            case OBJECT: {
                if (DBValueFormatting.typeNameContains(typeName, "UUID", DBConstants.TYPE_NAME_UUID2)) {
                    return DBIcon.TYPE_UUID;
                }
                if (DBValueFormatting.typeNameContains(typeName, "JSON", DBConstants.TYPE_NAME_JSON2)) {
                    return DBIcon.TYPE_JSON;
                }
                return DBIcon.TYPE_OBJECT;
            }
            case ANY: {
                return DBIcon.TYPE_ANY;
            }
        }
        return DBIcon.TYPE_UNKNOWN;
    }

    private static boolean typeNameContains(String typeName, String patternLC, String patternUC) {
        return typeName != null && (typeName.contains(patternLC) || typeName.contains(patternUC));
    }

    @NotNull
    public static DBPImage getObjectImage(DBPObject object) {
        return DBValueFormatting.getObjectImage(object, true);
    }

    @Nullable
    public static DBPImage getObjectImage(DBPObject object, boolean useDefault) {
        DBPImage image = null;
        if (object instanceof DBPImageProvider) {
            image = ((DBPImageProvider)((Object)object)).getObjectImage();
        }
        if (image == null) {
            if (object instanceof DBSTypedObject) {
                image = DBValueFormatting.getTypeImage((DBSTypedObject)object);
            }
            if (image == null && useDefault) {
                image = DBIcon.TYPE_OBJECT;
            }
        }
        return image;
    }

    @NotNull
    public static DBDBinaryFormatter getBinaryPresentation(@NotNull DBPDataSource dataSource) {
        DBDBinaryFormatter formatter;
        String id = dataSource.getContainer().getPreferenceStore().getString("resultset.binary.representation");
        if (id != null && (formatter = DBValueFormatting.getBinaryPresentation(id)) != null) {
            return formatter;
        }
        return DBConstants.BINARY_FORMATS[0];
    }

    @Nullable
    public static DBDBinaryFormatter getBinaryPresentation(String id) {
        DBDBinaryFormatter[] dBDBinaryFormatterArray = DBConstants.BINARY_FORMATS;
        int n = DBConstants.BINARY_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            DBDBinaryFormatter formatter = dBDBinaryFormatterArray[n2];
            if (formatter.getId().equals(id)) {
                return formatter;
            }
            ++n2;
        }
        return null;
    }

    public static String getDefaultBinaryFileEncoding(@NotNull DBPDataSource dataSource) {
        DBPPreferenceStore preferenceStore = dataSource.getContainer().getPreferenceStore();
        String fileEncoding = preferenceStore.getString("content.hex.encoding");
        if (CommonUtils.isEmpty((String)fileEncoding)) {
            fileEncoding = GeneralUtils.getDefaultFileEncoding();
        }
        return fileEncoding;
    }

    @Nullable
    public static Number convertStringToNumber(String text, Class<?> hintType, @NotNull DBDDataFormatter formatter) {
        if (text == null || text.length() == 0) {
            return null;
        }
        try {
            if (hintType == Long.class) {
                try {
                    return Long.valueOf(text);
                }
                catch (NumberFormatException numberFormatException) {
                    return new BigInteger(text);
                }
            }
            if (hintType == Integer.class) {
                return Integer.valueOf(text);
            }
            if (hintType == Short.class) {
                return Short.valueOf(text);
            }
            if (hintType == Byte.class) {
                return Byte.valueOf(text);
            }
            if (hintType == Float.class) {
                return Float.valueOf(text);
            }
            if (hintType == Double.class) {
                return Double.valueOf(text);
            }
            if (hintType == BigInteger.class) {
                return new BigInteger(text);
            }
            return new BigDecimal(text);
        }
        catch (NumberFormatException e) {
            try {
                return (Number)formatter.parseValue(text, hintType);
            }
            catch (ParseException parseException) {
                log.debug("Can't parse numeric value [" + text + "] using formatter: " + e.getMessage());
                return null;
            }
        }
    }

    public static String convertNumberToNativeString(Number value) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        if (value instanceof Float || value instanceof Double) {
            return NATIVE_DECIMAL_FORMATTER.format(value);
        }
        return value.toString();
    }

    public static String getBooleanString(boolean propertyValue) {
        return propertyValue ? "yes" : "no";
    }

    public static String formatBinaryString(@NotNull DBPDataSource dataSource, @NotNull byte[] data, @NotNull DBDDisplayFormat format) {
        return DBValueFormatting.formatBinaryString(dataSource, data, format, false);
    }

    public static String formatBinaryString(@NotNull DBPDataSource dataSource, @NotNull byte[] data, @NotNull DBDDisplayFormat format, boolean forceLimit) {
        int maxLength;
        DBDBinaryFormatter formatter = format == DBDDisplayFormat.NATIVE && dataSource instanceof SQLDataSource ? ((SQLDataSource)dataSource).getSQLDialect().getNativeBinaryFormatter() : DBValueFormatting.getBinaryPresentation(dataSource);
        int length = data.length;
        if ((format == DBDDisplayFormat.UI || forceLimit) && length > (maxLength = dataSource.getContainer().getPreferenceStore().getInt("resultset.binary.stringMaxLength"))) {
            length = maxLength;
        }
        String string = formatter.toString(data, 0, length);
        if (format == DBDDisplayFormat.NATIVE || length == data.length) {
            return string;
        }
        return String.valueOf(string) + "..." + " [" + data.length + "]";
    }

    @NotNull
    public static String getDefaultValueDisplayString(@Nullable Object value, @NotNull DBDDisplayFormat format) {
        boolean hasToString;
        if (DBUtils.isNullValue(value)) {
            if (format == DBDDisplayFormat.UI) {
                return "[NULL]";
            }
            return "";
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof DBPNamedObject) {
            return ((DBPNamedObject)value).getName();
        }
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType() == Byte.TYPE) {
                byte[] bytes = (byte[])value;
                int length = bytes.length;
                if (length > 2000) {
                    length = 2000;
                }
                String string = CommonUtils.toHexString((byte[])bytes, (int)0, (int)length);
                return bytes.length > 2000 ? String.valueOf(string) + "..." : string;
            }
            StringBuilder str = new StringBuilder("{");
            int length = Array.getLength(value);
            int i = 0;
            while (i < length) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(DBValueFormatting.getDefaultValueDisplayString(Array.get(value, i), format));
                ++i;
            }
            str.append("}");
            return str.toString();
        }
        if (value instanceof Collection) {
            StringBuilder str = new StringBuilder("{");
            boolean first = true;
            for (Object item : (Collection)value) {
                if (!first) {
                    str.append(", ");
                }
                first = false;
                str.append(DBValueFormatting.getDefaultValueDisplayString(item, format));
            }
            str.append("}");
            return str.toString();
        }
        String className = value.getClass().getName();
        if (className.startsWith("java.lang") || className.startsWith("java.util")) {
            return value.toString();
        }
        try {
            hasToString = value.getClass().getMethod("toString", new Class[0]).getDeclaringClass() != Object.class;
        }
        catch (Throwable e) {
            log.debug(e);
            hasToString = false;
        }
        if (hasToString) {
            return value.toString();
        }
        return "[" + value.getClass().getSimpleName() + "]";
    }
}

