/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVObject;
import org.jkiss.utils.CommonUtils;

public class DBVEntity
extends DBVObject
implements DBSEntity,
DBPQualifiedObject {
    private static final String[] DESC_COLUMN_PATTERNS = new String[]{"title", "name", "label", "display", "displayname", "description", "comment", "remark", "information", "email"};
    private static final int MIN_DESC_COLUMN_LENGTH = 4;
    private static final int MAX_DESC_COLUMN_LENGTH = 1000;
    private final DBVContainer container;
    private String name;
    private String description;
    private String descriptionColumnNames;
    List<DBVEntityConstraint> entityConstraints;
    List<DBVEntityAttribute> entityAttributes;
    Map<String, String> properties;
    List<DBVColorOverride> colorOverrides;

    public DBVEntity(DBVContainer container, String name, String descriptionColumnNames) {
        this.container = container;
        this.name = name;
        this.descriptionColumnNames = descriptionColumnNames;
    }

    public DBVEntity(DBVContainer container, DBVEntity copy) {
        this.container = container;
        this.name = copy.name;
        this.descriptionColumnNames = copy.descriptionColumnNames;
        if (!CommonUtils.isEmpty(copy.entityConstraints)) {
            this.entityConstraints = new ArrayList<DBVEntityConstraint>(copy.entityConstraints.size());
            for (DBVEntityConstraint c : copy.entityConstraints) {
                this.entityConstraints.add(new DBVEntityConstraint(this, c));
            }
        }
        if (!CommonUtils.isEmpty(copy.entityAttributes)) {
            this.entityAttributes = new ArrayList<DBVEntityAttribute>(copy.entityAttributes.size());
            for (DBVEntityAttribute attribute : copy.entityAttributes) {
                this.entityAttributes.add(new DBVEntityAttribute(this, null, attribute));
            }
        }
        if (!CommonUtils.isEmpty(copy.properties)) {
            this.properties = new LinkedHashMap<String, String>(copy.properties);
        }
    }

    @Nullable
    public DBSEntity getRealEntity(DBRProgressMonitor monitor) throws DBException {
        DBSObjectContainer realContainer = this.container.getRealContainer(monitor);
        if (realContainer == null) {
            return null;
        }
        DBSObject realObject = realContainer.getChild(monitor, this.name);
        if (realObject instanceof DBSEntity) {
            return (DBSEntity)realObject;
        }
        log.warn("Entity '" + this.name + "' not found in '" + realContainer.getName() + "'");
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public DBVContainer getParentObject() {
        return this.container;
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        return this.container.getDataSource();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    @Override
    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.VIRTUAL_ENTITY;
    }

    @Nullable
    public String getProperty(String name) {
        return CommonUtils.isEmpty(this.properties) ? null : this.properties.get(name);
    }

    public void setProperty(String name, @Nullable String value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, String>();
        }
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    @Override
    @NotNull
    public Collection<? extends DBSEntityAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        Collection<? extends DBSEntityAttribute> realAttributes;
        DBSEntity realEntity = this.getRealEntity(monitor);
        if (realEntity != null && !CommonUtils.isEmpty(realAttributes = realEntity.getAttributes(monitor))) {
            return realAttributes;
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) {
        try {
            return DBUtils.findObject(this.getAttributes(monitor), attributeName);
        }
        catch (DBException e) {
            log.error("Can't obtain real entity's attributes", e);
            return null;
        }
    }

    @Nullable
    public DBVEntityAttribute getVirtualAttribute(DBDAttributeBinding binding, boolean create) {
        if (this.entityAttributes != null || create) {
            DBSObject[] path;
            DBVEntityAttribute topAttribute;
            if (this.entityAttributes == null) {
                this.entityAttributes = new ArrayList<DBVEntityAttribute>();
            }
            if ((topAttribute = DBUtils.findObject(this.entityAttributes, (path = DBUtils.getObjectPath(binding, true))[0].getName())) == null && create) {
                topAttribute = new DBVEntityAttribute(this, null, path[0].getName());
                this.entityAttributes.add(topAttribute);
            }
            if (topAttribute != null) {
                int i = 1;
                while (i < path.length) {
                    DBVEntityAttribute nextAttribute = topAttribute.getChild(path[i].getName());
                    if (nextAttribute == null) {
                        if (create) {
                            nextAttribute = new DBVEntityAttribute(this, topAttribute, path[i].getName());
                        } else {
                            log.debug("Can't find hierarchical attribute '" + binding + "'");
                            return null;
                        }
                    }
                    topAttribute = nextAttribute;
                    ++i;
                }
            }
            return topAttribute;
        }
        return null;
    }

    void addVirtualAttribute(DBVEntityAttribute attribute) {
        if (this.entityAttributes == null) {
            this.entityAttributes = new ArrayList<DBVEntityAttribute>();
        }
        this.entityAttributes.add(attribute);
    }

    void resetVirtualAttribute(DBVEntityAttribute attribute) {
        this.entityAttributes.remove(attribute);
    }

    @Nullable
    public Collection<? extends DBVEntityConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.entityConstraints;
    }

    public DBVEntityConstraint getBestIdentifier() {
        if (this.entityConstraints == null) {
            this.entityConstraints = new ArrayList<DBVEntityConstraint>();
        }
        if (this.entityConstraints.isEmpty()) {
            this.entityConstraints.add(new DBVEntityConstraint(this, DBSEntityConstraintType.VIRTUAL_KEY, "PRIMARY"));
        }
        for (DBVEntityConstraint constraint : this.entityConstraints) {
            if (!constraint.getConstraintType().isUnique()) continue;
            return constraint;
        }
        return this.entityConstraints.get(0);
    }

    void addConstraint(DBVEntityConstraint constraint) {
        if (this.entityConstraints == null) {
            this.entityConstraints = new ArrayList<DBVEntityConstraint>();
        }
        this.entityConstraints.add(constraint);
    }

    @Override
    @Nullable
    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Override
    @Nullable
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public String getDescriptionColumnNames() {
        return this.descriptionColumnNames;
    }

    public void setDescriptionColumnNames(String descriptionColumnNames) {
        this.descriptionColumnNames = descriptionColumnNames;
    }

    public Collection<DBSEntityAttribute> getDescriptionColumns(DBRProgressMonitor monitor, DBSEntity entity) throws DBException {
        return DBVEntity.getDescriptionColumns(monitor, entity, this.descriptionColumnNames);
    }

    public static Collection<DBSEntityAttribute> getDescriptionColumns(DBRProgressMonitor monitor, DBSEntity entity, String descColumns) throws DBException {
        if (CommonUtils.isEmpty((String)descColumns)) {
            return Collections.emptyList();
        }
        ArrayList<DBSEntityAttribute> result = new ArrayList<DBSEntityAttribute>();
        Collection<? extends DBSEntityAttribute> attributes = entity.getAttributes(monitor);
        if (!CommonUtils.isEmpty(attributes)) {
            StringTokenizer st = new StringTokenizer(descColumns, ",");
            while (st.hasMoreTokens()) {
                String colName = st.nextToken();
                for (DBSEntityAttribute dBSEntityAttribute : attributes) {
                    if (!colName.equalsIgnoreCase(dBSEntityAttribute.getName())) continue;
                    result.add(dBSEntityAttribute);
                }
            }
        }
        return result;
    }

    public static String getDefaultDescriptionColumn(DBRProgressMonitor monitor, DBSEntityAttribute keyColumn) throws DBException {
        assert (keyColumn.getParentObject() != null);
        Collection<? extends DBSEntityAttribute> allColumns = keyColumn.getParentObject().getAttributes(monitor);
        if (allColumns == null || allColumns.isEmpty()) {
            return null;
        }
        if (allColumns.size() == 1) {
            return DBUtils.getQuotedIdentifier(keyColumn);
        }
        TreeMap<String, DBSEntityAttribute> stringColumns = new TreeMap<String, DBSEntityAttribute>();
        for (DBSEntityAttribute dBSEntityAttribute : allColumns) {
            if (dBSEntityAttribute == keyColumn || dBSEntityAttribute.getDataKind() != DBPDataKind.STRING || dBSEntityAttribute.getMaxLength() >= 1000L || dBSEntityAttribute.getMaxLength() < 4L) continue;
            stringColumns.put(dBSEntityAttribute.getName(), dBSEntityAttribute);
        }
        if (stringColumns.isEmpty()) {
            return DBUtils.getQuotedIdentifier(keyColumn);
        }
        if (stringColumns.size() > 1) {
            String[] stringArray = DESC_COLUMN_PATTERNS;
            int n = DESC_COLUMN_PATTERNS.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                for (String columnName : stringColumns.keySet()) {
                    if (!columnName.toLowerCase(Locale.ENGLISH).contains(string)) continue;
                    return DBUtils.getQuotedIdentifier((DBSObject)stringColumns.get(columnName));
                }
                ++n2;
            }
        }
        return DBUtils.getQuotedIdentifier((DBSObject)stringColumns.values().iterator().next());
    }

    public List<DBVColorOverride> getColorOverrides() {
        return this.colorOverrides;
    }

    public void setColorOverrides(List<DBVColorOverride> colorOverrides) {
        this.colorOverrides = colorOverrides;
    }

    public void setColorOverride(DBDAttributeBinding attribute, Object value, String foreground, String background) {
        String attrName = attribute.getName();
        DBVColorOverride co = new DBVColorOverride(attrName, DBCLogicalOperator.EQUALS, new Object[]{value}, foreground, background);
        if (this.colorOverrides == null) {
            this.colorOverrides = new ArrayList<DBVColorOverride>();
        } else {
            Iterator<DBVColorOverride> iterator = this.colorOverrides.iterator();
            while (iterator.hasNext()) {
                DBVColorOverride c = iterator.next();
                if (!c.matches(attrName, DBCLogicalOperator.EQUALS, co.getAttributeValues())) continue;
                iterator.remove();
            }
        }
        this.colorOverrides.add(co);
    }

    public void addColorOverride(DBVColorOverride color) {
        if (this.colorOverrides == null) {
            this.colorOverrides = new ArrayList<DBVColorOverride>();
        }
        this.colorOverrides.add(color);
    }

    public void removeColorOverride(DBDAttributeBinding attribute) {
        if (this.colorOverrides == null) {
            return;
        }
        String attrName = attribute.getName();
        this.colorOverrides.removeIf(c -> c.getAttributeName().equals(attrName));
    }

    public void removeAllColorOverride() {
        if (this.colorOverrides == null) {
            return;
        }
        this.colorOverrides.clear();
    }

    @Override
    public boolean hasValuableData() {
        if (!CommonUtils.isEmpty((String)this.descriptionColumnNames) || !CommonUtils.isEmpty(this.properties)) {
            return true;
        }
        if (!CommonUtils.isEmpty(this.entityConstraints)) {
            for (DBVEntityConstraint c : this.entityConstraints) {
                if (!c.hasAttributes()) continue;
                return true;
            }
        }
        if (!CommonUtils.isEmpty(this.entityAttributes)) {
            for (DBVEntityAttribute attr : this.entityAttributes) {
                if (!attr.hasValuableData()) continue;
                return true;
            }
        }
        return !CommonUtils.isEmpty(this.colorOverrides);
    }

    @Override
    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName(this.getDataSource(), this.container, this);
    }

    public String toString() {
        return this.name;
    }
}

