/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.transformers;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.ProxyValueHandler;
import org.jkiss.dbeaver.model.impl.data.transformers.TransformerPresentationAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.time.ExtendedDateFormat;

public class EpochTimeAttributeTransformer
implements DBDAttributeTransformer {
    private static final Log log = Log.getLog(EpochTimeAttributeTransformer.class);
    private static final String PROP_UNIT = "unit";
    private static final SimpleDateFormat FORMAT_MILLIS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH);
    private static final SimpleDateFormat FORMAT_SECONDS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    private static final SimpleDateFormat FORMAT_NANOS = new ExtendedDateFormat("yyyy-MM-dd HH:mm:ss.ffffff", Locale.ENGLISH);

    @Override
    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, String> options) throws DBException {
        attribute.setPresentationAttribute(new TransformerPresentationAttribute(attribute, "EpochTime", -1, DBPDataKind.DATETIME));
        EpochUnit unit = EpochUnit.milliseconds;
        if (options.containsKey(PROP_UNIT)) {
            try {
                unit = EpochUnit.valueOf(options.get(PROP_UNIT));
            }
            catch (IllegalArgumentException e) {
                log.error("Bad unit option", e);
            }
        }
        attribute.setTransformHandler(new EpochValueHandler(attribute.getValueHandler(), unit));
    }

    static enum EpochUnit {
        seconds,
        milliseconds,
        nanoseconds;

    }

    private class EpochValueHandler
    extends ProxyValueHandler {
        private final EpochUnit unit;

        public EpochValueHandler(DBDValueHandler target, EpochUnit unit) {
            super(target);
            this.unit = unit;
        }

        @Override
        @NotNull
        public String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
            if (value instanceof Number) {
                long dateValue = ((Number)value).longValue();
                switch (this.unit) {
                    case seconds: {
                        return FORMAT_SECONDS.format(new Date(dateValue * 1000L));
                    }
                    case nanoseconds: {
                        return FORMAT_NANOS.format(new Date(dateValue / 1000L));
                    }
                }
                return FORMAT_MILLIS.format(new Date(dateValue));
            }
            return DBValueFormatting.getDefaultValueDisplayString(value, format);
        }

        @Override
        @Nullable
        public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy) throws DBCException {
            if (object instanceof String) {
                try {
                    switch (this.unit) {
                        case seconds: {
                            return FORMAT_SECONDS.parse((String)object).getTime() / 1000L;
                        }
                        case milliseconds: {
                            return FORMAT_MILLIS.parse((String)object).getTime();
                        }
                        case nanoseconds: {
                            return FORMAT_NANOS.parse((String)object).getTime() * 1000L;
                        }
                    }
                }
                catch (Exception e) {
                    log.debug("Error parsing time value", e);
                }
            }
            return super.getValueFromObject(session, type, object, copy);
        }
    }
}

