/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;

public class InvalidateJob
extends DataSourceJob {
    private static final Log log = Log.getLog(InvalidateJob.class);
    private long timeSpent;
    private List<ContextInvalidateResult> invalidateResults = new ArrayList<ContextInvalidateResult>();
    private Runnable feedbackHandler;

    public InvalidateJob(DBPDataSource dataSource) {
        super("Invalidate " + dataSource.getContainer().getName(), dataSource.getDefaultInstance().getDefaultContext(false));
    }

    public List<ContextInvalidateResult> getInvalidateResults() {
        return this.invalidateResults;
    }

    public long getTimeSpent() {
        return this.timeSpent;
    }

    public Runnable getFeedbackHandler() {
        return this.feedbackHandler;
    }

    public void setFeedbackHandler(Runnable feedbackHandler) {
        this.feedbackHandler = feedbackHandler;
    }

    @Override
    protected IStatus run(DBRProgressMonitor monitor) {
        DBPDataSource dataSource = this.getExecutionContext().getDataSource();
        this.invalidateResults = InvalidateJob.invalidateDataSource(monitor, dataSource, false, this.feedbackHandler);
        return Status.OK_STATUS;
    }

    /*
     * WARNING - void declaration
     */
    public static List<ContextInvalidateResult> invalidateDataSource(DBRProgressMonitor monitor, DBPDataSource dataSource, boolean disconnectOnFailure, Runnable feedback) {
        ArrayList<ContextInvalidateResult> invalidateResults = new ArrayList<ContextInvalidateResult>();
        DBPDataSourceContainer container = dataSource.getContainer();
        DBWNetworkHandler[] activeHandlers = container.getActiveNetworkHandlers();
        boolean networkOK = true;
        int goodContextsNumber = 0;
        int aliveContextsNumber = 0;
        if (activeHandlers != null && activeHandlers.length > 0) {
            void var11_14;
            DBWNetworkHandler[] dBWNetworkHandlerArray = activeHandlers;
            int n = activeHandlers.length;
            boolean n2 = false;
            while (var11_14 < n) {
                DBWNetworkHandler nh = dBWNetworkHandlerArray[var11_14];
                monitor.subTask("Invalidate network [" + container.getName() + "]");
                try {
                    nh.invalidateHandler(monitor, dataSource);
                }
                catch (Exception e) {
                    invalidateResults.add(new ContextInvalidateResult(DBCExecutionContext.InvalidateResult.ERROR, e));
                    networkOK = false;
                    break;
                }
                ++var11_14;
            }
        }
        int totalContexts = 0;
        monitor.subTask("Invalidate connections of [" + container.getName() + "]");
        for (DBSInstance dBSInstance : dataSource.getAvailableInstances()) {
            DBCExecutionContext[] dBCExecutionContextArray = dBSInstance.getAllContexts();
            int n = dBCExecutionContextArray.length;
            int n2 = 0;
            while (n2 < n) {
                block22: {
                    DBCExecutionContext context = dBCExecutionContextArray[n2];
                    ++totalContexts;
                    if (networkOK) {
                        long startTime = System.currentTimeMillis();
                        try {
                            try {
                                DBCExecutionContext.InvalidateResult result = context.invalidateContext(monitor, disconnectOnFailure);
                                if (result != DBCExecutionContext.InvalidateResult.ERROR) {
                                    ++goodContextsNumber;
                                }
                                if (result == DBCExecutionContext.InvalidateResult.ALIVE) {
                                    ++aliveContextsNumber;
                                }
                                invalidateResults.add(new ContextInvalidateResult(result, null));
                            }
                            catch (Exception e) {
                                invalidateResults.add(new ContextInvalidateResult(DBCExecutionContext.InvalidateResult.ERROR, e));
                                System.currentTimeMillis();
                                break block22;
                            }
                        }
                        catch (Throwable throwable) {
                            System.currentTimeMillis();
                            throw throwable;
                        }
                        System.currentTimeMillis();
                    }
                }
                ++n2;
            }
        }
        if (goodContextsNumber > 0 && goodContextsNumber == aliveContextsNumber) {
            return invalidateResults;
        }
        if (goodContextsNumber == 0 && disconnectOnFailure) {
            try {
                container.disconnect(monitor);
            }
            catch (Exception exception) {
                log.error("Error closing unaccessible datasource", exception);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (ContextInvalidateResult result : invalidateResults) {
                if (result.error == null) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(result.error.getMessage());
            }
            DBUserInterface.getInstance().showError("Forced disconnect", "Datasource '" + container.getName() + "' was disconnected: destination database unreachable.\n" + stringBuilder);
        }
        if (goodContextsNumber == 0) {
            DBeaverNotifications.showNotification(dataSource, "reconnect", "Datasource invalidate failed", DBPMessageType.ERROR, feedback);
        } else {
            DBeaverNotifications.showNotification(dataSource, "reconnect", "Datasource was invalidated\n\nLive connection count: " + goodContextsNumber + "/" + totalContexts, DBPMessageType.INFORMATION);
        }
        return invalidateResults;
    }

    @Override
    protected void canceling() {
        this.getThread().interrupt();
    }

    public static class ContextInvalidateResult {
        public final DBCExecutionContext.InvalidateResult result;
        public final Exception error;

        ContextInvalidateResult(DBCExecutionContext.InvalidateResult result, Exception error) {
            this.result = result;
            this.error = error;
        }

        public String toString() {
            return this.result.name();
        }
    }
}

