/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class JDBCBasicDataTypeCache<OWNER extends DBSObject, OBJECT extends JDBCDataType>
extends JDBCObjectCache<OWNER, OBJECT> {
    private static final Log log = Log.getLog(JDBCBasicDataTypeCache.class);
    protected final OWNER owner;
    protected final Set<String> ignoredTypes = new HashSet<String>();

    public JDBCBasicDataTypeCache(OWNER owner) {
        this.owner = owner;
        this.setCaseSensitive(false);
    }

    @Override
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OWNER owner) throws SQLException {
        return session.getMetaData().getTypeInfo().getSourceStatement();
    }

    @Override
    protected OBJECT fetchObject(@NotNull JDBCSession session, @NotNull OWNER owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        String name = JDBCUtils.safeGetString((ResultSet)dbResult, "TYPE_NAME");
        if (CommonUtils.isEmpty((String)name)) {
            return null;
        }
        if (this.ignoredTypes.contains(name.toUpperCase(Locale.ENGLISH))) {
            return null;
        }
        int valueType = JDBCUtils.safeGetInt((ResultSet)dbResult, "DATA_TYPE");
        if (valueType == -2 && (name.contains("varchar") || name.contains("VARCHAR"))) {
            log.warn("Inconsistent string data type name/id: " + name + "(" + valueType + "). Setting to " + 12);
            valueType = 12;
        }
        return this.makeDataType(dbResult, name, valueType);
    }

    @NotNull
    protected OBJECT makeDataType(@NotNull JDBCResultSet dbResult, String name, int valueType) {
        return (OBJECT)new JDBCDataType<OWNER>(this.owner, valueType, name, JDBCUtils.safeGetString((ResultSet)dbResult, "LOCAL_TYPE_NAME"), JDBCUtils.safeGetBoolean((ResultSet)dbResult, "UNSIGNED_ATTRIBUTE"), JDBCUtils.safeGetInt((ResultSet)dbResult, "SEARCHABLE") != 0, JDBCUtils.safeGetInt((ResultSet)dbResult, "PRECISION"), JDBCUtils.safeGetInt((ResultSet)dbResult, "MINIMUM_SCALE"), JDBCUtils.safeGetInt((ResultSet)dbResult, "MAXIMUM_SCALE"));
    }

    private OBJECT makeDataType(OWNER owner, int valueType, String name, @Nullable String remarks, boolean unsigned, boolean searchable, int precision, int minScale, int maxScale) {
        return (OBJECT)new JDBCDataType<OWNER>(this.owner, valueType, name, remarks, unsigned, searchable, precision, minScale, maxScale);
    }

    public void fillStandardTypes(OWNER owner) {
        ArrayList standardTypes = new ArrayList();
        Collections.addAll(standardTypes, this.makeDataType(owner, 4, "INTEGER", null, false, true, 0, 0, 0), this.makeDataType(owner, 6, "FLOAT", null, false, true, 0, 0, 0), this.makeDataType(owner, 7, "REAL", null, false, true, 0, 0, 0), this.makeDataType(owner, 8, "DOUBLE PRECISION", null, false, true, 0, 0, 0), this.makeDataType(owner, 2, "NUMBER", null, false, true, 0, 0, 0), this.makeDataType(owner, 3, "DECIMAL", null, false, true, 0, 0, 0), this.makeDataType(owner, 5, "SMALLINT", null, false, true, 0, 0, 0), this.makeDataType(owner, -5, "BIGINT", null, false, true, 0, 0, 0), this.makeDataType(owner, -7, "BIT", null, false, true, 0, 0, 0), this.makeDataType(owner, 12, "VARCHAR", null, false, true, 0, 0, 0), this.makeDataType(owner, -3, "VARBINARY", null, false, true, 0, 0, 0), this.makeDataType(owner, 91, "DATE", null, false, true, 0, 0, 0), this.makeDataType(owner, 92, "TIME", null, false, true, 0, 0, 0), this.makeDataType(owner, 93, "TIMESTAMP", null, false, true, 0, 0, 0), this.makeDataType(owner, 2004, "BLOB", null, false, true, 0, 0, 0), this.makeDataType(owner, 2005, "CLOB", null, false, true, 0, 0, 0), this.makeDataType(owner, 16, "BOOLEAN", null, false, true, 0, 0, 0), this.makeDataType(owner, 1111, "OBJECT", null, false, true, 0, 0, 0));
        this.setCache(standardTypes);
    }

    public DBSDataType getCachedObject(int typeID) {
        for (JDBCDataType type : this.getCachedObjects()) {
            if (type.getTypeID() != typeID) continue;
            return type;
        }
        return null;
    }
}

