/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermission;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermissionsOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreTableBase
extends JDBCTable<PostgreDataSource, PostgreSchema>
implements PostgreClass,
PostgreScriptObject,
PostgrePermissionsOwner,
DBPNamedObject2 {
    private static final Log log = Log.getLog(PostgreTableBase.class);
    private long oid;
    private long ownerId;
    private String description;
    private boolean isPartition;
    private Object acl;
    private String[] relOptions;

    protected PostgreTableBase(PostgreSchema catalog) {
        super((DBSObjectContainer)catalog, false);
    }

    protected PostgreTableBase(PostgreSchema catalog, ResultSet dbResult) {
        super((DBSObjectContainer)catalog, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relname"), true);
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"relowner");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
        this.isPartition = ((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(10, 0) && JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"relispartition");
        this.acl = JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"relacl");
        if (((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(8, 2)) {
            this.relOptions = (String[])JDBCUtils.safeGetArray((ResultSet)dbResult, (String)"reloptions");
        }
    }

    public PostgreTableBase(PostgreSchema container, DBSEntity source, boolean persisted) {
        super((DBSObjectContainer)container, source, persisted);
        if (source instanceof PostgreTableBase) {
            this.description = ((PostgreTableBase)source).description;
            this.isPartition = ((PostgreTableBase)source).isPartition;
        }
    }

    public JDBCStructCache<PostgreSchema, ? extends PostgreClass, ? extends PostgreAttribute> getCache() {
        return ((PostgreSchema)this.getContainer()).tableCache;
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return ((PostgreSchema)this.getContainer()).getDatabase();
    }

    @Property(viewable=true, editable=false, updatable=false, order=9)
    public long getObjectId() {
        return this.oid;
    }

    @Property(order=90)
    @Nullable
    public String[] getRelOptions() {
        return this.relOptions;
    }

    @Property(viewable=true, editable=true, updatable=true, multiline=true, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Property(viewable=true, editable=false, updatable=false, order=10)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return this.getDatabase().getRoleById(monitor, this.ownerId);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    @Override
    @NotNull
    public PostgreSchema getSchema() {
        DBSObjectContainer parentObject = super.getParentObject();
        assert (parentObject != null);
        return (PostgreSchema)parentObject;
    }

    public List<PostgreTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((PostgreSchema)this.getContainer()).tableCache.getChildren(monitor, (PostgreSchema)this.getContainer(), this);
    }

    public PostgreTableColumn getAttributeByPos(DBRProgressMonitor monitor, int position) throws DBException {
        for (PostgreTableColumn attr : this.getAttributes(monitor)) {
            if (attr.getOrdinalPosition() != position) continue;
            return attr;
        }
        return null;
    }

    public List<PostgreTableColumn> getCachedAttributes() {
        DBSObjectCache childrenCache = ((PostgreSchema)this.getContainer()).tableCache.getChildrenCache(this);
        if (childrenCache != null) {
            return childrenCache.getCachedObjects();
        }
        return Collections.emptyList();
    }

    public PostgreTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (PostgreTableColumn)((PostgreSchema)this.getContainer()).tableCache.getChild(monitor, (PostgreSchema)this.getContainer(), this, attributeName);
    }

    public Collection<PostgreTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public PostgreTableConstraintBase getConstraint(@NotNull DBRProgressMonitor monitor, String ukName) throws DBException {
        return null;
    }

    @Association
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Association
    public synchronized Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((PostgreSchema)this.getContainer()).constraintCache.clearObjectCache(this);
        ((PostgreSchema)this.getContainer()).indexCache.clearObjectCache(this);
        return ((PostgreSchema)this.getContainer()).tableCache.refreshObject(monitor, (PostgreSchema)this.getContainer(), this);
    }

    @Override
    public Collection<PostgrePermission> getPermissions(DBRProgressMonitor monitor, boolean includeNestedObjects) throws DBException {
        if (!this.isPersisted()) {
            return Collections.emptyList();
        }
        List<PostgrePermission> tablePermissions = PostgreUtils.extractPermissionsFromACL(monitor, this, this.acl);
        if (!includeNestedObjects) {
            return tablePermissions;
        }
        tablePermissions = new ArrayList<PostgrePermission>(tablePermissions);
        for (PostgreTableColumn column : CommonUtils.safeCollection((Collection)this.getAttributes(monitor))) {
            if (column.getAcl() == null || column.isHidden()) continue;
            tablePermissions.addAll(column.getPermissions(monitor, true));
        }
        return tablePermissions;
    }

    public boolean isPartition() {
        return this.isPartition;
    }

    public void appendTableModifiers(DBRProgressMonitor monitor, StringBuilder ddl) {
    }

    public static class TablespaceListProvider
    implements IPropertyValueListProvider<PostgreTableBase> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(PostgreTableBase object) {
            try {
                Collection<PostgreTablespace> tablespaces = object.getDatabase().getTablespaces((DBRProgressMonitor)new VoidProgressMonitor());
                return tablespaces.toArray(new Object[tablespaces.size()]);
            }
            catch (DBException e) {
                log.error((Object)e);
                return new Object[0];
            }
        }
    }
}

