/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreCollation
implements PostgreObject {
    private PostgreSchema schema;
    private long oid;
    private String name;

    public PostgreCollation(PostgreSchema schema, ResultSet dbResult) throws SQLException {
        this.schema = schema;
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"collname");
    }

    @Property(viewable=true, order=1)
    @NotNull
    public PostgreSchema getSchema() {
        return this.schema;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    public long getObjectId() {
        return this.oid;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.schema;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.schema.getDataSource();
    }

    public boolean isPersisted() {
        return true;
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.schema.getDatabase();
    }
}

