/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermissionsOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureParameter;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.CreateProcedurePage;
import org.jkiss.utils.CommonUtils;

public class PostgreProcedureManager
extends SQLObjectEditor<PostgreProcedure, PostgreSchema>
implements DBEObjectRenamer<PostgreProcedure> {
    @Nullable
    public DBSObjectCache<PostgreSchema, PostgreProcedure> getObjectsCache(PostgreProcedure object) {
        return ((PostgreSchema)object.getContainer()).proceduresCache;
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected void validateObjectProperties(SQLObjectEditor.ObjectChangeCommand command) throws DBException {
        if (CommonUtils.isEmpty((String)((PostgreProcedure)command.getObject()).getName())) {
            throw new DBException("Function name cannot be empty");
        }
    }

    protected PostgreProcedure createDatabaseObject(final DBRProgressMonitor monitor, DBECommandContext context, final PostgreSchema parent, Object copyFrom) {
        return (PostgreProcedure)new UITask<PostgreProcedure>(){

            protected PostgreProcedure runTask() {
                CreateFunctionPage editPage = new CreateFunctionPage(parent, monitor);
                if (!editPage.edit()) {
                    return null;
                }
                PostgreProcedure newProcedure = new PostgreProcedure(parent);
                newProcedure.setName(editPage.getProcedureName());
                newProcedure.setLanguage(editPage.getLanguage());
                newProcedure.setReturnType(editPage.getReturnType());
                return newProcedure;
            }
        }.execute();
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actions, (PostgreProcedure)command.getObject());
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            this.createOrReplaceProcedureQuery(actionList, (PostgreProcedure)command.getObject());
        }
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        String objectType = ((PostgreProcedure)command.getObject()).getProcedureTypeName();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop function", "DROP " + objectType + " " + ((PostgreProcedure)command.getObject()).getFullQualifiedSignature()));
    }

    private void createOrReplaceProcedureQuery(List<DBEPersistAction> actions, PostgreProcedure procedure) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create function", procedure.getBody(), true));
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<PostgreProcedure, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        boolean isDDL;
        if (command.getProperty((Object)"description") != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment function", "COMMENT ON " + ((PostgreProcedure)command.getObject()).getProcedureTypeName() + " " + ((PostgreProcedure)command.getObject()).getFullQualifiedSignature() + " IS " + SQLUtils.quoteString((DBSObject)((DBSObject)command.getObject()), (String)((PostgreProcedure)command.getObject()).getDescription())));
        }
        if (isDDL = CommonUtils.getOption(options, (String)"ddl.source")) {
            try {
                PostgreUtils.getObjectGrantPermissionActions(monitor, (PostgrePermissionsOwner)command.getObject(), actions, options);
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    public void renameObject(DBECommandContext commandContext, PostgreProcedure object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        PostgreProcedure procedure = (PostgreProcedure)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename function", "ALTER " + ((PostgreProcedure)command.getObject()).getProcedureTypeName() + " " + DBUtils.getQuotedIdentifier((DBSObject)procedure.getSchema()) + "." + PostgreProcedure.makeOverloadedName(procedure.getSchema(), command.getOldName(), (List<PostgreProcedureParameter>)procedure.getParameters(monitor), true) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)procedure.getDataSource(), (String)command.getNewName())));
    }

    private static class CreateFunctionPage
    extends CreateProcedurePage {
        private final PostgreSchema parent;
        private final DBRProgressMonitor monitor;
        private PostgreLanguage language;
        private PostgreDataType returnType;

        public CreateFunctionPage(PostgreSchema parent, DBRProgressMonitor monitor) {
            super((DBSObjectContainer)parent);
            this.parent = parent;
            this.monitor = monitor;
        }

        public DBSProcedureType getPredefinedProcedureType() {
            return DBSProcedureType.FUNCTION;
        }

        protected void createExtraControls(Composite group) {
            ArrayList<PostgreLanguage> languages = new ArrayList<PostgreLanguage>();
            try {
                languages.addAll(this.parent.getDatabase().getLanguages(this.monitor));
            }
            catch (DBException e2) {
                log.error((Object)e2);
            }
            Combo languageCombo = UIUtils.createLabelCombo((Composite)group, (String)"Language", (int)12);
            for (PostgreLanguage lang : languages) {
                languageCombo.add(lang.getName());
            }
            languageCombo.addModifyListener(e -> {
                this.language = (PostgreLanguage)languages.get(languageCombo.getSelectionIndex());
            });
            languageCombo.setText("sql");
            ArrayList<PostgreDataType> dataTypes = new ArrayList<PostgreDataType>(this.parent.getDatabase().getDataSource().getLocalDataTypes());
            Combo dataTypeCombo = UIUtils.createLabelCombo((Composite)group, (String)"Return type", (int)4);
            for (PostgreDataType dt : dataTypes) {
                dataTypeCombo.add(dt.getName());
            }
            dataTypeCombo.addModifyListener(e -> {
                String dtName = dataTypeCombo.getText();
                this.returnType = !CommonUtils.isEmpty((String)dtName) ? this.parent.getDatabase().getDataSource().getLocalDataType(dtName) : null;
            });
            dataTypeCombo.setText("int4");
        }

        public PostgreLanguage getLanguage() {
            return this.language;
        }

        public PostgreDataType getReturnType() {
            return this.returnType;
        }
    }
}

