/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTable;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraint;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKey;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableIndex;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablespace;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public class OracleTableManager
extends SQLTableManager<OracleTable, OracleSchema>
implements DBEObjectRenamer<OracleTable> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{OracleTableColumn.class, OracleTableConstraint.class, OracleTableForeignKey.class, OracleTableIndex.class};

    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleTable> getObjectsCache(OracleTable object) {
        return object.getSchema().tableCache;
    }

    protected OracleTable createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, OracleSchema parent, Object copyFrom) {
        OracleTable table = new OracleTable(parent, "");
        try {
            this.setTableName(monitor, (DBSObjectContainer)parent, table);
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return table;
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"comment") == null) {
            StringBuilder query = new StringBuilder("ALTER TABLE ");
            query.append(((OracleTable)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ");
            this.appendTableModifiers(monitor, (OracleTable)command.getObject(), (SQLObjectEditor.NestedObjectCommand)command, query, true);
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(query.toString()));
        }
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<OracleTable, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        if (command.getProperty((Object)"comment") != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment table", "COMMENT ON TABLE " + ((OracleTable)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)((DBSObject)command.getObject()), (String)((OracleTable)command.getObject()).getComment())));
        }
    }

    protected void appendTableModifiers(DBRProgressMonitor monitor, OracleTable table, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter) {
        Object tablespace;
        if (tableProps.getProperty((Object)"tablespace") != null && (tablespace = table.getTablespace()) instanceof OracleTablespace) {
            if (table.isPersisted()) {
                ddl.append("\nMOVE TABLESPACE ").append(((OracleTablespace)tablespace).getName());
            } else {
                ddl.append("\nTABLESPACE ").append(((OracleTablespace)tablespace).getName());
            }
        }
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", "ALTER TABLE " + DBUtils.getQuotedIdentifier((DBSObject)((OracleTable)command.getObject()).getSchema()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)((OracleTable)command.getObject()).getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)((OracleTable)command.getObject()).getDataSource(), (String)command.getNewName())));
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        OracleTable object = (OracleTable)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table, "DROP " + (object.isView() ? "VIEW" : "TABLE") + " " + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + (!object.isView() && CommonUtils.getOption(options, (String)"deleteCascade") ? " CASCADE CONSTRAINTS" : "")));
    }

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public void renameObject(DBECommandContext commandContext, OracleTable object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }
}

