/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.oci;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.ext.oracle.oci.OracleHomeDescriptor;
import org.jkiss.dbeaver.ui.TextUtils;
import org.jkiss.dbeaver.utils.WinRegistry;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class OCIUtils {
    private static final Log log = Log.getLog(OCIUtils.class);
    public static final String WIN_REG_ORACLE = "SOFTWARE\\ORACLE";
    public static final String WIN_REG_ORA_HOME = "ORACLE_HOME";
    public static final String WIN_REG_ORA_HOME_NAME = "ORACLE_HOME_NAME";
    public static final String TNSNAMES_FILE_NAME = "tnsnames.ora";
    public static final String TNSNAMES_FILE_PATH = "network/admin/";
    private static final List<OracleHomeDescriptor> oraHomes = new ArrayList<OracleHomeDescriptor>();
    private static boolean oraHomesSearched = false;

    public static List<OracleHomeDescriptor> getOraHomes() {
        OCIUtils.checkOraHomes();
        return oraHomes;
    }

    private static boolean checkOraHomes() {
        if (!oraHomesSearched) {
            OCIUtils.findOraHomes();
            oraHomesSearched = true;
        }
        return !oraHomes.isEmpty();
    }

    public static OracleHomeDescriptor getOraHome(String oraHome) {
        if (CommonUtils.isEmpty((String)oraHome) || !OCIUtils.checkOraHomes()) {
            return null;
        }
        for (OracleHomeDescriptor home : oraHomes) {
            if (!OCIUtils.equalsFileName(home.getName(), oraHome)) continue;
            return home;
        }
        return null;
    }

    public static OracleHomeDescriptor getOraHomeByName(String oraHomeName) {
        if (CommonUtils.isEmpty((String)oraHomeName) || !OCIUtils.checkOraHomes()) {
            return null;
        }
        for (OracleHomeDescriptor home : oraHomes) {
            if (!OCIUtils.equalsFileName(home.getDisplayName(), oraHomeName)) continue;
            return home;
        }
        return null;
    }

    private static boolean equalsFileName(String file1, String file2) {
        if (DBeaverCore.getInstance().getLocalSystem().isWindows()) {
            return file1.equalsIgnoreCase(file2);
        }
        return file1.equals(file2);
    }

    public static OracleHomeDescriptor addOraHome(String oraHome) throws DBException {
        if (CommonUtils.isEmpty((String)oraHome)) {
            return null;
        }
        oraHome = CommonUtils.removeTrailingSlash((String)oraHome);
        boolean contains = false;
        for (OracleHomeDescriptor home : oraHomes) {
            if (!OCIUtils.equalsFileName(home.getName(), oraHome)) continue;
            contains = true;
            break;
        }
        if (!contains) {
            OracleHomeDescriptor homeDescriptor = new OracleHomeDescriptor(oraHome);
            oraHomes.add(0, homeDescriptor);
            return homeDescriptor;
        }
        return null;
    }

    private static void findOraHomes() {
        String oraHome;
        String path = System.getenv("PATH");
        if (path != null) {
            String[] stringArray = path.split(System.getProperty("path.separator"));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (token.toLowerCase().contains("oracle") && (token = CommonUtils.removeTrailingSlash((String)token)).toLowerCase().endsWith("bin")) {
                    String oraHome2 = token.substring(0, token.length() - 3);
                    try {
                        OCIUtils.addOraHome(oraHome2);
                    }
                    catch (DBException ex) {
                        log.warn((Object)("Wrong Oracle client home " + oraHome2), (Throwable)ex);
                    }
                }
                ++n2;
            }
        }
        if ((oraHome = System.getenv("ORA_HOME")) == null) {
            oraHome = System.getenv(WIN_REG_ORA_HOME);
        }
        if (oraHome != null) {
            try {
                OCIUtils.addOraHome(oraHome);
            }
            catch (DBException ex) {
                log.warn((Object)("Wrong Oracle client home " + oraHome), (Throwable)ex);
            }
        }
        if (DBeaverCore.getInstance().getLocalSystem().isWindows()) {
            try {
                List oracleKeys = WinRegistry.readStringSubKeys((int)-2147483646, (String)WIN_REG_ORACLE);
                if (oracleKeys != null) {
                    block9: for (String oracleKey : oracleKeys) {
                        Map valuesMap = WinRegistry.readStringValues((int)-2147483646, (String)("SOFTWARE\\ORACLE\\" + oracleKey));
                        if (valuesMap == null) continue;
                        for (String key : valuesMap.keySet()) {
                            if (!WIN_REG_ORA_HOME.equals(key)) continue;
                            try {
                                oraHome = (String)valuesMap.get(key);
                                OCIUtils.addOraHome(oraHome);
                            }
                            catch (DBException ex) {
                                log.warn((Object)("Wrong Oracle client home " + oraHome), (Throwable)ex);
                            }
                            continue block9;
                        }
                    }
                }
            }
            catch (Exception e) {
                log.warn((Object)"Error reading Windows registry", (Throwable)e);
            }
        }
    }

    public static String readWinRegistry(String oraHome, String name) {
        if (DBeaverCore.getInstance().getLocalSystem().isWindows()) {
            try {
                List oracleKeys = WinRegistry.readStringSubKeys((int)-2147483646, (String)WIN_REG_ORACLE);
                if (oracleKeys != null) {
                    for (String oracleKey : oracleKeys) {
                        String value;
                        String home = WinRegistry.readString((int)-2147483646, (String)("SOFTWARE\\ORACLE\\" + oracleKey), (String)WIN_REG_ORA_HOME);
                        if (!oraHome.equals(home) || (value = WinRegistry.readString((int)-2147483646, (String)("SOFTWARE\\ORACLE\\" + oracleKey), (String)name)) == null) continue;
                        return value;
                    }
                }
            }
            catch (Exception e) {
                log.warn((Object)"Error reading Windows registry", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFullOraVersion(String oraHome, boolean isInstantClient) {
        String sqlplus = String.valueOf(isInstantClient ? CommonUtils.makeDirectoryName((String)oraHome) : String.valueOf(CommonUtils.makeDirectoryName((String)oraHome)) + "bin/") + "sqlplus -version";
        try {
            Process p = Runtime.getRuntime().exec(sqlplus);
            try {
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String line;
                    do {
                        if ((line = input.readLine()) != null) continue;
                        return null;
                    } while (!line.startsWith("SQL*Plus: Release "));
                    String string = line.substring(18, line.indexOf(" ", 19));
                    return string;
                }
                finally {
                    IOUtils.close((Closeable)input);
                }
            }
            finally {
                p.destroy();
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Error reading Oracle client version from " + sqlplus), (Throwable)ex);
        }
        return null;
    }

    @Nullable
    public static File findTnsNamesFile(@Nullable File oraHome, boolean checkTnsAdmin) {
        String tnsAdmin;
        File tnsNamesFile = null;
        if (checkTnsAdmin && (tnsAdmin = System.getenv("TNS_ADMIN")) != null) {
            tnsNamesFile = new File(tnsAdmin, TNSNAMES_FILE_NAME);
        }
        if (!(tnsNamesFile != null && tnsNamesFile.exists() || oraHome == null || (tnsNamesFile = new File(oraHome, "network/admin/tnsnames.ora")).exists())) {
            tnsNamesFile = new File(oraHome, TNSNAMES_FILE_NAME);
        }
        if (tnsNamesFile != null && tnsNamesFile.exists()) {
            return tnsNamesFile;
        }
        return null;
    }

    public static Map<String, String> readTnsNames(@Nullable File oraHome, boolean checkTnsAdmin) {
        File tnsNamesFile = OCIUtils.findTnsNamesFile(oraHome, checkTnsAdmin);
        if (tnsNamesFile != null) {
            return OCIUtils.parseTnsNames(tnsNamesFile);
        }
        return Collections.emptyMap();
    }

    private static Map<String, String> parseTnsNames(File tnsnamesOra) {
        TreeMap<String, String> aliases = new TreeMap<String, String>();
        if (tnsnamesOra.exists()) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(tnsnamesOra));
                StringBuilder tnsDescription = new StringBuilder();
                String curAlias = null;
                while ((line = reader.readLine()) != null) {
                    String trimmedLine = line.trim();
                    if (trimmedLine.isEmpty() || trimmedLine.startsWith("#")) continue;
                    if (!line.startsWith(" ") && !line.startsWith("\t") && !line.startsWith("(") && line.contains("=")) {
                        int divPos = line.indexOf("=");
                        if (divPos < 0) continue;
                        String alias = line.substring(0, divPos);
                        if (alias.equalsIgnoreCase("IFILE")) {
                            String filePath = line.substring(divPos + 1).trim();
                            File extFile = new File(filePath);
                            if (!extFile.exists()) {
                                extFile = new File(tnsnamesOra.getParent(), filePath);
                            }
                            aliases.putAll(OCIUtils.parseTnsNames(extFile));
                            continue;
                        }
                        if (curAlias != null) {
                            aliases.put(curAlias, OCIUtils.getPlainTnsDescription(tnsDescription.toString()));
                        }
                        curAlias = alias.trim();
                        tnsDescription.setLength(0);
                        tnsDescription.append(line.substring(divPos + 1));
                        continue;
                    }
                    if (curAlias == null) continue;
                    tnsDescription.append(line);
                }
                if (curAlias != null) {
                    aliases.put(curAlias, OCIUtils.getPlainTnsDescription(tnsDescription.toString()));
                }
            }
            catch (IOException e) {
                log.debug((Object)e);
            }
        } else {
            log.debug((Object)("TNS names file '" + tnsnamesOra + "' doesn't exist"));
        }
        return aliases;
    }

    private static String getPlainTnsDescription(String line) {
        return TextUtils.compactWhiteSpaces((String)line.trim());
    }

    public static boolean isInstantClient(String oraHome) {
        File root = new File(System.mapLibraryName(String.valueOf(CommonUtils.makeDirectoryName((String)oraHome)) + "oci"));
        File bin = new File(System.mapLibraryName(String.valueOf(CommonUtils.makeDirectoryName((String)oraHome)) + "bin/" + "oci"));
        return root.exists() && !bin.exists();
    }
}

