/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectStatus;
import org.jkiss.dbeaver.ext.oracle.model.OracleTable;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraint;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraintBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableForeignKey;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.utils.CommonUtils;

public class OracleTableForeignKey
extends OracleTableConstraintBase
implements DBSTableForeignKey {
    private static final Log log = Log.getLog(OracleTableForeignKey.class);
    private OracleTableConstraint referencedKey;
    private DBSForeignKeyModifyRule deleteRule;

    public OracleTableForeignKey(@NotNull OracleTableBase oracleTable, @Nullable String name, @Nullable OracleObjectStatus status, @NotNull OracleTableConstraint referencedKey, @NotNull DBSForeignKeyModifyRule deleteRule) {
        super(oracleTable, name, DBSEntityConstraintType.FOREIGN_KEY, status, false);
        this.referencedKey = referencedKey;
        this.deleteRule = deleteRule;
    }

    public OracleTableForeignKey(DBRProgressMonitor monitor, OracleTable table, ResultSet dbResult) throws DBException {
        super((OracleTableBase)table, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_NAME"), DBSEntityConstraintType.FOREIGN_KEY, (OracleObjectStatus)((Object)CommonUtils.notNull((Object)((Object)((OracleObjectStatus)CommonUtils.valueOf(OracleObjectStatus.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"STATUS")))), (Object)((Object)OracleObjectStatus.ENABLED))), true);
        String refName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"R_CONSTRAINT_NAME");
        String refOwnerName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"R_OWNER");
        String refTableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"R_TABLE_NAME");
        OracleTableBase refTable = OracleTableBase.findTable(monitor, (OracleDataSource)table.getDataSource(), refOwnerName, refTableName);
        if (refTable == null) {
            log.warn((Object)("Referenced table '" + DBUtils.getSimpleQualifiedName((Object[])new Object[]{refOwnerName, refTableName}) + "' not found"));
        } else {
            this.referencedKey = refTable.getConstraint(monitor, refName);
            if (this.referencedKey == null) {
                log.warn((Object)("Referenced constraint '" + refName + "' not found in table '" + refTable.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'"));
                this.referencedKey = new OracleTableConstraint(refTable, "refName", DBSEntityConstraintType.UNIQUE_KEY, null, OracleObjectStatus.ERROR);
            }
        }
        String deleteRuleName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DELETE_RULE");
        this.deleteRule = "CASCADE".equals(deleteRuleName) ? DBSForeignKeyModifyRule.CASCADE : DBSForeignKeyModifyRule.NO_ACTION;
    }

    @Property(viewable=true, order=3)
    public OracleTableBase getReferencedTable() {
        return this.referencedKey == null ? null : (OracleTableBase)this.referencedKey.getTable();
    }

    @Property(id="reference", viewable=true, order=4)
    @Nullable
    public OracleTableConstraint getReferencedConstraint() {
        return this.referencedKey;
    }

    @Property(viewable=true, editable=true, listProvider=ConstraintModifyRuleListProvider.class, order=5)
    @NotNull
    public DBSForeignKeyModifyRule getDeleteRule() {
        return this.deleteRule;
    }

    @NotNull
    public DBSForeignKeyModifyRule getUpdateRule() {
        return DBSForeignKeyModifyRule.NO_ACTION;
    }

    public OracleTableBase getAssociatedEntity() {
        return this.getReferencedTable();
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((OracleTableBase)this.getTable()).getContainer(), this.getTable(), this});
    }

    public static class ConstraintModifyRuleListProvider
    implements IPropertyValueListProvider<JDBCTableForeignKey> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(JDBCTableForeignKey foreignKey) {
            return new DBSForeignKeyModifyRule[]{DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.CASCADE, DBSForeignKeyModifyRule.RESTRICT, DBSForeignKeyModifyRule.SET_NULL, DBSForeignKeyModifyRule.SET_DEFAULT};
        }
    }
}

