/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.ArrayList;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.MySQLMessages;
import org.jkiss.dbeaver.ext.mysql.edit.UserPropertyHandler;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLUser;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.prop.DBECommandComposite;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class MySQLCommandChangeUser
extends DBECommandComposite<MySQLUser, UserPropertyHandler> {
    protected MySQLCommandChangeUser(MySQLUser user) {
        super((DBPObject)user, MySQLMessages.edit_command_change_user_name);
    }

    public void updateModel() {
        for (Map.Entry entry : this.getProperties().entrySet()) {
            switch (UserPropertyHandler.valueOf((String)entry.getKey())) {
                case MAX_QUERIES: {
                    ((MySQLUser)this.getObject()).setMaxQuestions(CommonUtils.toInt(entry.getValue()));
                    break;
                }
                case MAX_UPDATES: {
                    ((MySQLUser)this.getObject()).setMaxUpdates(CommonUtils.toInt(entry.getValue()));
                    break;
                }
                case MAX_CONNECTIONS: {
                    ((MySQLUser)this.getObject()).setMaxConnections(CommonUtils.toInt(entry.getValue()));
                    break;
                }
                case MAX_USER_CONNECTIONS: {
                    ((MySQLUser)this.getObject()).setMaxUserConnections(CommonUtils.toInt(entry.getValue()));
                    break;
                }
            }
        }
    }

    public void validateCommand() throws DBException {
        String passValue = CommonUtils.toString((Object)this.getProperty(UserPropertyHandler.PASSWORD));
        String confirmValue = CommonUtils.toString((Object)this.getProperty(UserPropertyHandler.PASSWORD_CONFIRM));
        if (!CommonUtils.isEmpty((String)passValue) && !CommonUtils.equalObjects((Object)passValue, (Object)confirmValue)) {
            throw new DBException("Password confirmation value is invalid");
        }
    }

    public DBEPersistAction[] getPersistActions(DBRProgressMonitor monitor, Map<String, Object> options) {
        boolean newUser;
        ArrayList<SQLDatabasePersistAction> actions = new ArrayList<SQLDatabasePersistAction>();
        boolean bl = newUser = !((MySQLUser)this.getObject()).isPersisted();
        if (newUser) {
            actions.add(new SQLDatabasePersistAction(MySQLMessages.edit_command_change_user_action_create_new_user, "CREATE USER " + ((MySQLUser)this.getObject()).getFullName()){

                public void afterExecute(DBCSession session, Throwable error) {
                    if (error == null) {
                        ((MySQLUser)MySQLCommandChangeUser.this.getObject()).setPersisted(true);
                    }
                }
            });
        }
        StringBuilder script = new StringBuilder();
        MySQLDataSource dataSource = ((MySQLUser)this.getObject()).getDataSource();
        boolean hasSet = dataSource.isMariaDB() || dataSource.isServerVersionAtLeast(5, 7) ? this.generateAlterScript(script) : this.generateUpdateScript(script);
        if (hasSet) {
            actions.add(new SQLDatabasePersistAction(MySQLMessages.edit_command_change_user_action_update_user_record, script.toString()));
        }
        return actions.toArray(new DBEPersistAction[actions.size()]);
    }

    private boolean generateUpdateScript(StringBuilder script) {
        script.append("UPDATE mysql.user SET ");
        boolean hasSet = false;
        for (Map.Entry entry : this.getProperties().entrySet()) {
            if (entry.getKey() == UserPropertyHandler.PASSWORD_CONFIRM) continue;
            String delim = hasSet ? "," : "";
            switch (UserPropertyHandler.valueOf((String)entry.getKey())) {
                case PASSWORD: {
                    script.append(delim).append("Password=PASSWORD(").append(SQLUtils.quoteString((DBSObject)((DBSObject)this.getObject()), (String)CommonUtils.toString(entry.getValue()))).append(")");
                    hasSet = true;
                    break;
                }
                case MAX_QUERIES: {
                    script.append(delim).append("Max_Questions=").append(CommonUtils.toInt(entry.getValue()));
                    hasSet = true;
                    break;
                }
                case MAX_UPDATES: {
                    script.append(delim).append("Max_Updates=").append(CommonUtils.toInt(entry.getValue()));
                    hasSet = true;
                    break;
                }
                case MAX_CONNECTIONS: {
                    script.append(delim).append("Max_Connections=").append(CommonUtils.toInt(entry.getValue()));
                    hasSet = true;
                    break;
                }
                case MAX_USER_CONNECTIONS: {
                    script.append(delim).append("Max_User_Connections=").append(CommonUtils.toInt(entry.getValue()));
                    hasSet = true;
                    break;
                }
            }
        }
        script.append(" WHERE User='").append(((MySQLUser)this.getObject()).getUserName()).append("' AND Host='").append(((MySQLUser)this.getObject()).getHost()).append("'");
        return hasSet;
    }

    private boolean generateAlterScript(StringBuilder script) {
        boolean hasSet = false;
        boolean hasResOptions = false;
        script.append("ALTER USER ").append(((MySQLUser)this.getObject()).getFullName());
        if (this.getProperties().containsKey(UserPropertyHandler.PASSWORD.name())) {
            script.append("\nIDENTIFIED BY ").append(SQLUtils.quoteString((DBSObject)((DBSObject)this.getObject()), (String)CommonUtils.toString(this.getProperties().get(UserPropertyHandler.PASSWORD.name())))).append(" ");
            hasSet = true;
        }
        StringBuilder resOptions = new StringBuilder();
        for (Map.Entry entry : this.getProperties().entrySet()) {
            switch (UserPropertyHandler.valueOf((String)entry.getKey())) {
                case MAX_QUERIES: {
                    resOptions.append("\n\tMAX_QUERIES_PER_HOUR ").append(CommonUtils.toInt(entry.getValue()));
                    hasResOptions = true;
                    break;
                }
                case MAX_UPDATES: {
                    resOptions.append("\n\tMAX_UPDATES_PER_HOUR ").append(CommonUtils.toInt(entry.getValue()));
                    hasResOptions = true;
                    break;
                }
                case MAX_CONNECTIONS: {
                    resOptions.append("\n\tMAX_CONNECTIONS_PER_HOUR ").append(CommonUtils.toInt(entry.getValue()));
                    hasResOptions = true;
                    break;
                }
                case MAX_USER_CONNECTIONS: {
                    resOptions.append("\n\tMAX_USER_CONNECTIONS ").append(CommonUtils.toInt(entry.getValue()));
                    hasResOptions = true;
                }
            }
        }
        if (resOptions.length() > 0) {
            script.append("\nWITH").append((CharSequence)resOptions);
        }
        return hasSet || hasResOptions;
    }
}

