/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SQLServerSynonym
implements DBSAlias,
DBSObject,
DBPQualifiedObject,
SQLServerObject {
    private static final Log log = Log.getLog(SQLServerSynonym.class);
    private long objectId;
    private SQLServerSchema schema;
    private String name;
    private String targetObjectName;
    private String description;
    private boolean persisted;

    protected SQLServerSynonym(SQLServerSchema schema, long objectId, String name, String targetObjectName, boolean persisted) {
        this.schema = schema;
        this.objectId = objectId;
        this.name = name;
        this.targetObjectName = targetObjectName;
        this.persisted = persisted;
    }

    @Property(viewable=false, order=80)
    public long getObjectId() {
        return this.objectId;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public SQLServerSchema getParentObject() {
        return this.schema;
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return this.schema.getDataSource();
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.schema.getDatabase(), this.schema, this});
    }

    @Property(viewable=true, order=20)
    public DBSObject getTargetObject(DBRProgressMonitor monitor) throws DBException {
        int divPos = this.targetObjectName.indexOf("].[");
        if (divPos == -1) {
            log.debug((Object)("Bad target object name '" + this.targetObjectName + "' for synonym '" + this.getName() + "'"));
            return null;
        }
        String schemaName = DBUtils.getUnQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.targetObjectName.substring(0, divPos + 1));
        String objectName = DBUtils.getUnQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.targetObjectName.substring(divPos + 2));
        SQLServerSchema targetSchema = this.schema.getDatabase().getSchema(monitor, schemaName);
        if (targetSchema == null) {
            log.debug((Object)("Schema '" + schemaName + "' not found for synonym '" + this.getName() + "'"));
            return null;
        }
        return targetSchema.getChild(monitor, objectName);
    }
}

