/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolView;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCStatementImpl;

public class ExasolViewCache
extends JDBCStructCache<ExasolSchema, ExasolView, ExasolTableColumn> {
    private static final String SQL_COLS_VIEW = "SELECT c.*,CAST(NULL AS INTEGER) as key_seq FROM  \"$ODBCJDBC\".\"ALL_COLUMNS\"  c WHERE c.table_SCHEM = '%s' AND c.TABLE_name = '%s' order by ORDINAL_POSITION";
    private static final String SQL_COLS_ALL = "SELECT c.*,CAST(NULL AS INTEGER) as key_seq FROM  \"$ODBCJDBC\".\"ALL_COLUMNS\"  c WHERE c.table_SCHEM = '%s' order by c.TABLE_name,ORDINAL_POSITION";

    public ExasolViewCache() {
        super((Object)"TABLE_NAME");
    }

    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull ExasolSchema exasolSchema) throws SQLException {
        JDBCDatabaseMetaData meta = session.getMetaData();
        return meta.getTables("EXA_DB", exasolSchema.getName(), null, new String[]{"VIEW", "SYSTEM TABLE"}).getSourceStatement();
    }

    protected ExasolView fetchObject(@NotNull JDBCSession session, @NotNull ExasolSchema exasolSchema, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        return new ExasolView(session.getProgressMonitor(), exasolSchema, (ResultSet)dbResult);
    }

    protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull ExasolSchema exasolSchema, @Nullable ExasolView forView) throws SQLException {
        String sql = forView != null ? String.format(SQL_COLS_VIEW, ExasolUtils.quoteString(exasolSchema.getName()), ExasolUtils.quoteString(forView.getName())) : String.format(SQL_COLS_ALL, ExasolUtils.quoteString(exasolSchema.getName()));
        JDBCStatement dbStat = session.createStatement();
        ((JDBCStatementImpl)dbStat).setQueryString(sql);
        return dbStat;
    }

    protected ExasolTableColumn fetchChild(@NotNull JDBCSession session, @NotNull ExasolSchema exasolSchema, @NotNull ExasolView exasolView, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        return new ExasolTableColumn(session.getProgressMonitor(), exasolView, (ResultSet)dbResult);
    }
}

