/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.editor.tools;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.ext.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ext.erd.part.IColorizedPart;
import org.jkiss.dbeaver.ui.UIUtils;

public class SetPartColorAction
extends SelectionAction {
    private IStructuredSelection selection;

    public SetPartColorAction(ERDEditorPart part, IStructuredSelection selection) {
        super((IWorkbenchPart)part);
        this.selection = selection;
        this.setText("Set color");
        this.setToolTipText("Set figure color");
        this.setId("setFigureColor");
    }

    protected boolean calculateEnabled() {
        Object[] objectArray = this.selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof IColorizedPart) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void init() {
        super.init();
    }

    public void run() {
        this.execute(this.createColorCommand(this.selection.toArray()));
    }

    private Command createColorCommand(final Object[] objects) {
        return new Command(){
            private final Map<IColorizedPart, Color> oldColors = new HashMap<IColorizedPart, Color>();
            private Color newColor;

            public void execute() {
                Shell shell = UIUtils.createCenteredShell((Shell)SetPartColorAction.this.getWorkbenchPart().getSite().getShell());
                try {
                    ColorDialog colorDialog = new ColorDialog(shell);
                    RGB color = colorDialog.open();
                    if (color == null) {
                        return;
                    }
                    this.newColor = new Color((Device)Display.getCurrent(), color);
                    Object[] objectArray = objects;
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        if (item instanceof IColorizedPart) {
                            IColorizedPart colorizedPart = (IColorizedPart)item;
                            this.oldColors.put(colorizedPart, colorizedPart.getCustomBackgroundColor());
                            colorizedPart.customizeBackgroundColor(this.newColor);
                        }
                        ++n2;
                    }
                }
                finally {
                    shell.dispose();
                }
            }

            public void undo() {
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof IColorizedPart) {
                        IColorizedPart colorizedPart = (IColorizedPart)item;
                        colorizedPart.customizeBackgroundColor(this.oldColors.get(colorizedPart));
                    }
                    ++n2;
                }
            }

            public void redo() {
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof IColorizedPart) {
                        IColorizedPart colorizedPart = (IColorizedPart)item;
                        colorizedPart.customizeBackgroundColor(this.newColor);
                    }
                    ++n2;
                }
            }
        };
    }
}

