/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.editor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.CommonUtils;

public enum ERDAttributeVisibility {
    ALL("All"),
    KEYS("Any keys"),
    PRIMARY("Primary key"),
    NONE("None");

    private final String title;
    private static final Log log;

    static {
        log = Log.getLog(ERDAttributeVisibility.class);
    }

    private ERDAttributeVisibility(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public static ERDAttributeVisibility getDefaultVisibility(IPreferenceStore store) {
        String attrVisibilityString = store.getString("erd.attr.visibility");
        if (!CommonUtils.isEmpty((String)attrVisibilityString)) {
            try {
                return ERDAttributeVisibility.valueOf(attrVisibilityString);
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)e);
            }
        }
        return ALL;
    }

    public static void setDefaultVisibility(DBPPreferenceStore store, ERDAttributeVisibility visibility) {
        store.setValue("erd.attr.visibility", visibility.name());
    }
}

