/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.command;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;

public class AssociationReconnectTargetCommand
extends Command {
    protected ERDEntity sourceEntity;
    protected ERDEntity targetEntity;
    protected ERDAssociation relationship;
    protected ERDEntity oldTargetEntity;

    public boolean canExecute() {
        boolean returnVal = true;
        ERDEntity foreignKeyEntity = this.relationship.getSourceEntity();
        if (foreignKeyEntity.equals(this.targetEntity)) {
            returnVal = false;
        } else {
            List<ERDAssociation> relationships = this.targetEntity.getReferences();
            for (ERDAssociation relationship : relationships) {
                if (!relationship.getSourceEntity().equals(this.sourceEntity) || !relationship.getTargetEntity().equals(this.targetEntity)) continue;
                returnVal = false;
                break;
            }
        }
        return returnVal;
    }

    public void execute() {
        if (this.targetEntity != null) {
            this.oldTargetEntity.removeReferenceAssociation(this.relationship, true);
            this.relationship.setTargetEntity(this.targetEntity);
            this.targetEntity.addReferenceAssociation(this.relationship, true);
        }
    }

    public void setTargetEntity(ERDEntity targetEntity) {
        this.targetEntity = targetEntity;
    }

    public void setRelationship(ERDAssociation relationship) {
        this.relationship = relationship;
        this.oldTargetEntity = relationship.getTargetEntity();
        this.sourceEntity = relationship.getSourceEntity();
    }

    public void undo() {
        this.targetEntity.removeReferenceAssociation(this.relationship, true);
        this.relationship.setTargetEntity(this.oldTargetEntity);
        this.oldTargetEntity.addReferenceAssociation(this.relationship, true);
    }
}

