/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.command;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;

public class AssociationCreateCommand
extends Command {
    protected ERDAssociation association;
    protected ERDEntity sourceEntity;
    protected ERDEntity targetEntity;

    public boolean canExecute() {
        boolean returnValue = true;
        if (this.sourceEntity.equals(this.targetEntity)) {
            returnValue = false;
        } else {
            if (this.targetEntity == null) {
                return false;
            }
            List<ERDAssociation> relationships = this.targetEntity.getReferences();
            for (ERDAssociation currentRelationship : relationships) {
                if (!currentRelationship.getSourceEntity().equals(this.sourceEntity)) continue;
                returnValue = false;
                break;
            }
        }
        return returnValue;
    }

    public void execute() {
        this.association = this.createAssociation(this.sourceEntity, this.targetEntity, true);
    }

    public ERDEntity getSourceEntity() {
        return this.sourceEntity;
    }

    public void setSourceEntity(ERDEntity sourceEntity) {
        this.sourceEntity = sourceEntity;
    }

    public ERDEntity getTargetEntity() {
        return this.targetEntity;
    }

    public void setTargetEntity(ERDEntity targetEntity) {
        this.targetEntity = targetEntity;
    }

    public ERDAssociation getAssociation() {
        return this.association;
    }

    public void setAssociation(ERDAssociation association) {
        this.association = association;
    }

    public void redo() {
        this.sourceEntity.addAssociation(this.association, true);
        this.targetEntity.addReferenceAssociation(this.association, true);
    }

    public void undo() {
        this.sourceEntity.removeAssociation(this.association, true);
        this.targetEntity.removeReferenceAssociation(this.association, true);
    }

    protected ERDAssociation createAssociation(ERDEntity sourceEntity, ERDEntity targetEntity, boolean reflect) {
        return new ERDAssociation(sourceEntity, targetEntity, true);
    }
}

