/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.command;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.jkiss.dbeaver.ext.erd.model.ERDNote;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.dbeaver.ext.erd.part.NotePart;

public class NoteCreateCommand
extends Command {
    private DiagramPart diagramPart;
    private ERDNote note;
    private Point location;

    public NoteCreateCommand(DiagramPart diagram, ERDNote note, Point location) {
        this.diagramPart = diagram;
        this.note = note;
        this.location = location;
    }

    public void execute() {
        this.diagramPart.getDiagram().addNote(this.note, true);
        if (this.location != null) {
            for (Object diagramChild : this.diagramPart.getChildren()) {
                NotePart entityPart;
                if (!(diagramChild instanceof NotePart) || (entityPart = (NotePart)diagramChild).getNote() != this.note) continue;
                Dimension size = entityPart.getFigure().getPreferredSize();
                Rectangle newBounds = new Rectangle(this.location.x, this.location.y, size.width, size.height);
                entityPart.modifyBounds(newBounds);
                break;
            }
        }
    }

    public void undo() {
        this.diagramPart.getDiagram().removeNote(this.note, true);
    }
}

