/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.command;

import org.eclipse.gef.commands.Command;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.part.AssociationPart;

public class AssociationDeleteCommand
extends Command {
    protected final AssociationPart part;
    protected final ERDEntity sourceEntity;
    protected final ERDEntity targetEntity;
    protected final ERDAssociation association;

    public AssociationDeleteCommand(AssociationPart part) {
        this.part = part;
        this.association = part.getAssociation();
        this.sourceEntity = this.association.getSourceEntity();
        this.targetEntity = this.association.getTargetEntity();
    }

    public void execute() {
        this.part.markAssociatedAttributes(0);
        this.targetEntity.removeReferenceAssociation(this.association, true);
        this.sourceEntity.removeAssociation(this.association, true);
        this.association.setSourceEntity(null);
        this.association.setTargetEntity(null);
    }

    public void undo() {
        this.association.setSourceEntity(this.sourceEntity);
        this.association.setTargetEntity(this.targetEntity);
        this.sourceEntity.addAssociation(this.association, true);
        this.targetEntity.addReferenceAssociation(this.association, true);
    }
}

