/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.debug.ui.DBGConfigurationPanel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.registry.AbstractContextDescriptor;
import org.jkiss.utils.CommonUtils;

public class DebugConfigurationPanelDescriptor
extends AbstractContextDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.debug.ui.configurationPanels";
    private final String id;
    private final String name;
    private final String description;
    private final AbstractDescriptor.ObjectType implType;
    private List<String> supportedDataSources = new ArrayList<String>();

    public DebugConfigurationPanelDescriptor(IConfigurationElement config) {
        super(config);
        IConfigurationElement[] dsElements;
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
        this.description = config.getAttribute("description");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config, "class");
        IConfigurationElement[] iConfigurationElementArray = dsElements = config.getChildren("datasource");
        int n = dsElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement dsElement = iConfigurationElementArray[n2];
            String dsId = dsElement.getAttribute("id");
            String dsClassName = dsElement.getAttribute("class");
            if (dsId != null || dsClassName != null) {
                this.supportedDataSources.add(dsId != null ? dsId : dsClassName);
            }
            ++n2;
        }
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isValid() {
        return !CommonUtils.isEmpty((String)this.implType.getImplName());
    }

    public DBGConfigurationPanel createPanel() throws DBException {
        return (DBGConfigurationPanel)this.implType.createInstance(DBGConfigurationPanel.class);
    }

    public String toString() {
        return this.id;
    }

    public boolean supportsDataSource(DBPDataSourceContainer dataSource) {
        return this.supportedDataSources.contains(dataSource.getDriver().getProviderId()) || this.supportedDataSources.contains(dataSource.getDriver().getDriverClassName());
    }
}

