/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferSettings;

public class StreamProducerSettings
implements IDataTransferSettings {
    private Map<String, EntityMapping> entityMapping = new HashMap<String, EntityMapping>();
    private Map<Object, Object> processorProperties;
    private int maxRows;

    public EntityMapping getEntityMapping(DBSEntity entity) {
        String fullName = DBUtils.getObjectFullName((DBPNamedObject)entity, (DBPEvaluationContext)DBPEvaluationContext.DML);
        EntityMapping mapping = this.entityMapping.get(fullName);
        if (mapping == null) {
            mapping = new EntityMapping(entity);
            this.entityMapping.put(fullName, mapping);
        }
        return mapping;
    }

    public Map<Object, Object> getProcessorProperties() {
        return this.processorProperties;
    }

    public void setProcessorProperties(Map<Object, Object> processorProperties) {
        this.processorProperties = processorProperties;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public void loadSettings(IRunnableContext runnableContext, DataTransferSettings dataTransferSettings, IDialogSettings dialogSettings) {
    }

    @Override
    public void saveSettings(IDialogSettings dialogSettings) {
    }

    public static class AttributeMapping {
        private final DBDValueHandler targetValueHandler;
        private DBSEntityAttribute targetAttribute;
        private String targetAttributeName;
        private String sourceAttributeName;
        private int sourceAttributeIndex = -1;
        private boolean skip;
        private String defaultValue;
        private MappingType mappingType = MappingType.NONE;
        private StreamDataImporterColumnInfo sourceColumn;

        public AttributeMapping(DBSEntityAttribute attr) {
            this.targetAttribute = attr;
            this.targetAttributeName = attr.getName();
            this.targetValueHandler = DBUtils.findValueHandler((DBPDataSource)attr.getDataSource(), (DBSTypedObject)attr);
        }

        public MappingType getMappingType() {
            return this.mappingType;
        }

        public void setMappingType(MappingType mappingType) {
            this.mappingType = mappingType;
        }

        public DBSEntityAttribute getTargetAttribute() {
            return this.targetAttribute;
        }

        public DBDValueHandler getTargetValueHandler() {
            return this.targetValueHandler;
        }

        public String getSourceAttributeName() {
            return this.sourceAttributeName;
        }

        public void setSourceAttributeName(String sourceAttributeName) {
            this.sourceAttributeName = sourceAttributeName;
        }

        public int getSourceAttributeIndex() {
            return this.sourceAttributeIndex;
        }

        public void setSourceAttributeIndex(int sourceAttributeIndex) {
            this.sourceAttributeIndex = sourceAttributeIndex;
        }

        public String getTargetAttributeName() {
            return this.targetAttributeName;
        }

        public void setTargetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
        }

        public boolean isSkip() {
            return this.skip;
        }

        public void setSkip(boolean skip) {
            this.skip = skip;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public StreamDataImporterColumnInfo getSourceColumn() {
            return this.sourceColumn;
        }

        public void setSourceColumn(StreamDataImporterColumnInfo sourceColumn) {
            this.sourceColumn = sourceColumn;
        }

        public boolean isValuable() {
            return this.mappingType == MappingType.IMPORT || this.mappingType == MappingType.DEFAULT_VALUE;
        }

        public String toString() {
            return String.valueOf(this.sourceAttributeName) + " " + (Object)((Object)this.mappingType) + " )" + this.targetAttributeName + ")";
        }

        public static enum MappingType {
            NONE("none"),
            IMPORT("import"),
            DEFAULT_VALUE("custom value"),
            SKIP("skip");

            private final String title;

            private MappingType(String title) {
                this.title = title;
            }

            public String getTitle() {
                return this.title;
            }
        }
    }

    public static class EntityMapping {
        private String entityName;
        private DBSEntity entity;
        private List<AttributeMapping> attributeMappings = new ArrayList<AttributeMapping>();
        private List<StreamDataImporterColumnInfo> streamColumns = new ArrayList<StreamDataImporterColumnInfo>();

        public EntityMapping(DBSEntity entity) {
            this.entity = entity;
            this.entityName = DBUtils.getObjectFullName((DBPNamedObject)entity, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }

        public EntityMapping(String entityName) {
            this.entityName = entityName;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public DBSEntity getEntity() {
            return this.entity;
        }

        public List<AttributeMapping> getAttributeMappings() {
            return this.attributeMappings;
        }

        public List<AttributeMapping> getValuableAttributeMappings() {
            ArrayList<AttributeMapping> result = new ArrayList<AttributeMapping>();
            for (AttributeMapping am : this.attributeMappings) {
                if (!am.isValuable()) continue;
                result.add(am);
            }
            return result;
        }

        public AttributeMapping getAttributeMapping(DBSEntityAttribute attr) {
            AttributeMapping am2;
            for (AttributeMapping am2 : this.attributeMappings) {
                if (!attr.getName().equals(am2.getTargetAttributeName())) continue;
                return am2;
            }
            am2 = new AttributeMapping(attr);
            this.attributeMappings.add(am2);
            return am2;
        }

        public boolean isComplete() {
            for (AttributeMapping am : this.attributeMappings) {
                if (am.getMappingType() != AttributeMapping.MappingType.NONE) continue;
                return false;
            }
            return true;
        }

        public List<StreamDataImporterColumnInfo> getStreamColumns() {
            return this.streamColumns;
        }

        public void setStreamColumns(List<StreamDataImporterColumnInfo> streamColumns) {
            this.streamColumns.clear();
            this.streamColumns.addAll(streamColumns);
        }

        public StreamDataImporterColumnInfo getStreamColumn(String name) {
            for (StreamDataImporterColumnInfo col : this.streamColumns) {
                if (!name.equals(col.getColumnName())) continue;
                return col;
            }
            return null;
        }
    }
}

