/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.utils.CommonUtils;

class DataTransferPagePipes
extends ActiveWizardPage<DataTransferWizard> {
    private TableViewer nodesTable;

    DataTransferPagePipes() {
        super(DTMessages.data_transfer_wizard_init_name);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.nodesTable = new TableViewer(composite, 67588);
        this.nodesTable.getTable().setLayoutData((Object)new GridData(1808));
        this.nodesTable.getTable().setLinesVisible(true);
        this.nodesTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        CellLabelProvider labelProvider = new CellLabelProvider(){

            public void update(ViewerCell cell) {
                TransferTarget element = (TransferTarget)cell.getElement();
                if (cell.getColumnIndex() == 0) {
                    if (element.processor != null) {
                        cell.setImage(DBeaverIcons.getImage((DBPImage)element.processor.getIcon()));
                        cell.setText(element.processor.getName());
                    } else {
                        cell.setImage(DBeaverIcons.getImage((DBPImage)element.node.getIcon()));
                        cell.setText(element.node.getName());
                    }
                } else if (element.processor != null) {
                    cell.setText(element.processor.getDescription());
                } else {
                    cell.setText(element.node.getDescription());
                }
            }
        };
        TableViewerColumn columnName = new TableViewerColumn(this.nodesTable, 16384);
        columnName.setLabelProvider(labelProvider);
        columnName.getColumn().setText(DTMessages.data_transfer_wizard_init_column_exported);
        TableViewerColumn columnDesc = new TableViewerColumn(this.nodesTable, 16384);
        columnDesc.setLabelProvider(labelProvider);
        columnDesc.getColumn().setText(DTMessages.data_transfer_wizard_init_column_description);
        if (((DataTransferWizard)this.getWizard()).getSettings().isConsumerOptional()) {
            this.setTitle(DTMessages.data_transfer_wizard_init_title);
            this.setDescription(DTMessages.data_transfer_wizard_init_description);
            this.loadConsumers();
        } else {
            this.setTitle(DTMessages.data_transfer_wizard_producers_title);
            this.setDescription(DTMessages.data_transfer_wizard_producers_description);
            this.loadProducers();
        }
        this.nodesTable.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DataTransferPagePipes.this.nodesTable.getSelection();
                TransferTarget target = !selection.isEmpty() ? (TransferTarget)selection.getFirstElement() : null;
                DataTransferSettings settings = ((DataTransferWizard)DataTransferPagePipes.this.getWizard()).getSettings();
                if (target == null) {
                    settings.selectConsumer(null, null, true);
                } else if (settings.isConsumerOptional()) {
                    settings.selectConsumer(target.node, target.processor, true);
                } else if (settings.isProducerOptional()) {
                    settings.selectProducer(target.node, target.processor, true);
                }
                DataTransferPagePipes.this.updatePageCompletion();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                if (DataTransferPagePipes.this.isPageComplete()) {
                    ((DataTransferWizard)DataTransferPagePipes.this.getWizard()).getContainer().showPage(((DataTransferWizard)DataTransferPagePipes.this.getWizard()).getNextPage((IWizardPage)DataTransferPagePipes.this));
                }
            }
        });
        this.nodesTable.getTable().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                UIUtils.packColumns((Table)DataTransferPagePipes.this.nodesTable.getTable());
                UIUtils.maxTableColumnsWidth((Table)DataTransferPagePipes.this.nodesTable.getTable());
                DataTransferPagePipes.this.nodesTable.getTable().removeControlListener((ControlListener)this);
            }
        });
        this.setControl((Control)composite);
        DataTransferNodeDescriptor consumer = ((DataTransferWizard)this.getWizard()).getSettings().getConsumer();
        DataTransferNodeDescriptor producer = ((DataTransferWizard)this.getWizard()).getSettings().getProducer();
        DataTransferProcessorDescriptor processor = ((DataTransferWizard)this.getWizard()).getSettings().getProcessor();
        if (consumer != null || producer != null) {
            Collection targets = (Collection)this.nodesTable.getInput();
            for (TransferTarget target : targets) {
                if (target.node != consumer && target.node != producer || target.processor != processor) continue;
                this.nodesTable.setSelection((ISelection)new StructuredSelection((Object)target));
                break;
            }
        }
        this.updatePageCompletion();
    }

    private void loadConsumers() {
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        List<DBSObject> objects = settings.getSourceObjects();
        ArrayList<TransferTarget> transferTargets = new ArrayList<TransferTarget>();
        for (DataTransferNodeDescriptor consumer : DataTransferRegistry.getInstance().getAvailableConsumers(objects)) {
            Collection<DataTransferProcessorDescriptor> processors = consumer.getAvailableProcessors(objects);
            if (CommonUtils.isEmpty(processors)) {
                transferTargets.add(new TransferTarget(consumer, null));
                continue;
            }
            for (DataTransferProcessorDescriptor processor : processors) {
                transferTargets.add(new TransferTarget(consumer, processor));
            }
        }
        this.nodesTable.setInput(transferTargets);
    }

    private void loadProducers() {
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        List<DBSObject> objects = settings.getSourceObjects();
        ArrayList<TransferTarget> transferTargets = new ArrayList<TransferTarget>();
        for (DataTransferNodeDescriptor producer : DataTransferRegistry.getInstance().getAvailableProducers(objects)) {
            Collection<DataTransferProcessorDescriptor> processors = producer.getAvailableProcessors(objects);
            if (CommonUtils.isEmpty(processors)) {
                transferTargets.add(new TransferTarget(producer, null));
                continue;
            }
            for (DataTransferProcessorDescriptor processor : processors) {
                transferTargets.add(new TransferTarget(producer, processor));
            }
        }
        this.nodesTable.setInput(transferTargets);
    }

    protected boolean determinePageCompletion() {
        return ((DataTransferWizard)this.getWizard()).getSettings().getConsumer() != null;
    }

    private static class TransferTarget {
        DataTransferNodeDescriptor node;
        DataTransferProcessorDescriptor processor;

        private TransferTarget(DataTransferNodeDescriptor node, DataTransferProcessorDescriptor processor) {
            this.node = node;
            this.processor = processor;
        }
    }
}

